/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.text.Normalizer;
import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class MarcTranslatedReader
implements MarcReader {
    MarcReader reader;
    CharConverter convert;
    Normalizer.Form unicodeNormalize = null;

    public MarcTranslatedReader(MarcReader r, boolean unicodeNormalizeBool) {
        this.reader = r;
        this.convert = new AnselToUnicode();
        if (unicodeNormalizeBool) {
            this.unicodeNormalize = Normalizer.Form.NFC;
        }
    }

    public MarcTranslatedReader(MarcReader r, String unicodeNormalizeStr) {
        this.reader = r;
        this.convert = new AnselToUnicode();
        this.unicodeNormalize = unicodeNormalizeStr.equals("KC") ? Normalizer.Form.NFKC : (unicodeNormalizeStr.equals("KD") ? Normalizer.Form.NFKD : (unicodeNormalizeStr.equals("C") ? Normalizer.Form.NFC : (unicodeNormalizeStr.equals("D") ? Normalizer.Form.NFD : null)));
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Record next() {
        Record rec = this.reader.next();
        Leader l = rec.getLeader();
        boolean is_utf_8 = false;
        if (l.getCharCodingScheme() == 'a') {
            is_utf_8 = true;
        }
        if (is_utf_8 && this.unicodeNormalize == null) {
            return rec;
        }
        List<VariableField> fields = rec.getVariableFields();
        for (VariableField f : fields) {
            if (!(f instanceof DataField)) continue;
            DataField field = (DataField)f;
            List<Subfield> subfields = field.getSubfields();
            for (Subfield sf : subfields) {
                String oldData;
                String newData = oldData = sf.getData();
                if (!is_utf_8) {
                    newData = this.convert.convert(newData);
                }
                if (this.unicodeNormalize != null) {
                    newData = Normalizer.normalize(newData, this.unicodeNormalize);
                }
                if (oldData.equals(newData)) continue;
                sf.setData(newData);
            }
        }
        l.setCharCodingScheme('a');
        rec.setLeader(l);
        return rec;
    }
}

