/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.MarcReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.RecordImpl;
import org.marc4j.marc.impl.Verifier;

public class MarcScriptedRecordEditReader
implements MarcReader {
    Record currentRecord = null;
    private final MarcReader reader;
    private final Properties remapProperties;
    private final String deleteSubfieldsSpec;
    static Pattern newControlFieldDef = Pattern.compile("=?([0][0][0-9]) [ ]?(.*)");
    static Pattern newDataFieldDef = Pattern.compile("=?([0-9][0-9][0-9]) [ ]?([0-9 \\|])([0-9 \\|])([$].*)");
    static Pattern newSubfieldDef = Pattern.compile("[$]([a-z0-9])(([^$]|\\[$]|[$][{][0-9]*[}])*)(.*)");
    static MarcFactory factory = null;
    static Pattern oneArg = Pattern.compile("[a-z]*[(]\"((\\\"|[^\"])*)\"[ ]*[)]");
    static Pattern twoArgs = Pattern.compile("[a-z]*[(]\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\"[)]");
    static Pattern threeArgs = Pattern.compile("[a-z]*[(][ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\"[)]");
    static Pattern fourArgs = Pattern.compile("[a-z]*[(][ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\",[ ]*\"((\\\"|[^\"])*)\"[)]");
    static Pattern twoConditionals = Pattern.compile("[a-z]*[(]([a-z]*[(].*[)]),[ ]*([a-z]*[(].*[)])[)]");
    static Pattern oneConditional = Pattern.compile("[a-z]*[(]([a-z]*[(].*[)])[)]");
    static Pattern argAndConditional = Pattern.compile("[a-z]*[(][ ]*\"((\\\"|[^\"])*)\",[ ]*([a-z]*[(].*[)])[)]");

    public MarcScriptedRecordEditReader(MarcReader reader, String deleteSubfieldStr, Properties remapProperties) {
        this.reader = reader;
        this.deleteSubfieldsSpec = deleteSubfieldStr;
        this.remapProperties = remapProperties;
    }

    public MarcScriptedRecordEditReader(MarcReader reader, String deleteSubfieldStr) {
        this.reader = reader;
        this.deleteSubfieldsSpec = deleteSubfieldStr;
        this.remapProperties = null;
    }

    public MarcScriptedRecordEditReader(MarcReader reader, Properties remapProperties) {
        this.reader = reader;
        this.deleteSubfieldsSpec = null;
        this.remapProperties = remapProperties;
    }

    @Override
    public boolean hasNext() {
        if (this.currentRecord == null) {
            this.currentRecord = this.next();
        }
        return this.currentRecord != null;
    }

    @Override
    public Record next() {
        if (this.currentRecord != null) {
            Record tmp = this.currentRecord;
            this.currentRecord = null;
            return tmp;
        }
        while (this.currentRecord == null) {
            boolean keepRecord;
            if (!this.reader.hasNext()) {
                return null;
            }
            Record rec = null;
            rec = this.reader.next();
            if (this.deleteSubfieldsSpec != null) {
                this.deleteSubfields(rec);
            }
            if (this.remapProperties != null && !(keepRecord = this.remapRecord(rec))) continue;
            this.currentRecord = rec;
        }
        return this.currentRecord;
    }

    void deleteSubfields(Record rec) {
        String[] fieldSpecs;
        for (String fieldSpec : fieldSpecs = this.deleteSubfieldsSpec.split(":")) {
            String tag = fieldSpec.substring(0, 3);
            String subfield = null;
            if (fieldSpec.length() > 3) {
                subfield = fieldSpec.substring(3);
            }
            List<VariableField> list = rec.getVariableFields(tag);
            for (VariableField field : list) {
                if (!(field instanceof DataField)) continue;
                DataField df = (DataField)field;
                if (subfield != null) {
                    List<Subfield> sfs = df.getSubfields(subfield.charAt(0));
                    if (sfs == null || sfs.size() == 0) continue;
                    rec.removeVariableField(df);
                    for (Subfield sf : sfs) {
                        df.removeSubfield(sf);
                    }
                    rec.addVariableField(df);
                    continue;
                }
                rec.removeVariableField(df);
            }
        }
    }

    private boolean remapRecord(Record rec) {
        List<VariableField> fieldS = ((RecordImpl)rec).getVariableFieldsWithLeader();
        ArrayList<VariableField> fToDelete = new ArrayList<VariableField>();
        ArrayList<VariableField> fToInsert = new ArrayList<VariableField>();
        boolean keepRecord = true;
        for (VariableField field : fieldS) {
            String tag = field.getTag();
            String tagPlus0 = tag + "_0";
            if (this.remapProperties.containsKey(tagPlus0)) {
                if (Verifier.isControlNumberField(tag)) {
                    int i = 0;
                    while (this.remapProperties.containsKey(tag + "_" + i)) {
                        String remapString = this.remapProperties.getProperty(tag + "_" + i);
                        String[] mapParts = remapString.split("=>");
                        if (this.eval(mapParts[0], field, rec)) {
                            keepRecord &= this.process(mapParts[1], field, null, fToDelete, fToInsert, rec);
                        }
                        ++i;
                    }
                } else {
                    ArrayList<Subfield> sfToDelete = new ArrayList<Subfield>();
                    int i = 0;
                    while (this.remapProperties.containsKey(tag + "_" + i)) {
                        String remapString = this.remapProperties.getProperty(tag + "_" + i);
                        String[] mapParts = remapString.split("=>");
                        if (this.eval(mapParts[0], field, rec)) {
                            keepRecord &= this.process(mapParts[1], field, sfToDelete, fToDelete, fToInsert, rec);
                        }
                        ++i;
                    }
                    if (sfToDelete.size() != 0) {
                        for (Subfield sf : sfToDelete) {
                            ((DataField)field).removeSubfield(sf);
                        }
                    }
                }
            }
            if (keepRecord) continue;
            break;
        }
        String tagPlus0 = "once_0";
        if (keepRecord && this.remapProperties.containsKey(tagPlus0)) {
            int i = 0;
            while (this.remapProperties.containsKey("once_" + i)) {
                String remapString = this.remapProperties.getProperty("once_" + i);
                String[] mapParts = remapString.split("=>");
                if (this.eval(mapParts[0], null, rec)) {
                    keepRecord &= this.process(mapParts[1], null, null, fToDelete, fToInsert, rec);
                }
                ++i;
            }
        }
        if (keepRecord && fToDelete.size() != 0) {
            for (VariableField field : fToDelete) {
                rec.removeVariableField(field);
            }
        }
        if (keepRecord && fToInsert.size() != 0) {
            for (VariableField field : fToInsert) {
                if (field instanceof DataField) {
                    int index = 0;
                    for (DataField df : rec.getDataFields()) {
                        if (df.getTag().compareTo(field.getTag()) >= 0) break;
                        ++index;
                    }
                    rec.getDataFields().add(index, (DataField)field);
                    continue;
                }
                if (field.getTag().equals("001")) {
                    rec.addVariableField(field);
                    continue;
                }
                if (!(field instanceof ControlField)) continue;
                int index = 0;
                for (ControlField df : rec.getControlFields()) {
                    if (df.getTag().compareTo(field.getTag()) >= 0) break;
                    ++index;
                }
                rec.getControlFields().add(index, (ControlField)field);
            }
        }
        return keepRecord;
    }

    private boolean eval(String conditional, VariableField field, Record record) {
        if (conditional.startsWith("true()")) {
            return true;
        }
        if (conditional.startsWith("not(")) {
            String arg = this.getOneConditional(conditional);
            if (arg != null) {
                return !this.eval(arg, field, record);
            }
        } else if (conditional.startsWith("indicatormatches(")) {
            String[] args = this.getTwoArgs(conditional);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1 && args[1].length() == 1) {
                char indicator1 = ((DataField)field).getIndicator1();
                char indicator2 = ((DataField)field).getIndicator2();
                return !(args[0].charAt(0) != '*' && args[0].charAt(0) != indicator1 || args[1].charAt(0) != '*' && args[1].charAt(0) != indicator2);
            }
        } else if (conditional.startsWith("subfieldmatches(")) {
            String[] args = this.getTwoArgs(conditional);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List<Subfield> subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    if (!sf.getData().matches(args[1])) continue;
                    return true;
                }
            } else if (field != null && field instanceof ControlField && args.length == 2) {
                String dataToMatch = ((ControlField)field).getData();
                try {
                    if (args[0].matches("[0-9]+")) {
                        int start = Integer.parseInt(args[0]);
                        dataToMatch = dataToMatch.substring(start, start + 1);
                    } else if (args[0].matches("[0-9]+-[0-9]+")) {
                        int dash = args[0].indexOf(45);
                        int start = Integer.parseInt(args[0].substring(0, dash));
                        int end = Integer.parseInt(args[0].substring(dash + 1));
                        dataToMatch = dataToMatch.substring(start, end + 1);
                    }
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    return false;
                }
                if (dataToMatch.matches(args[1])) {
                    return true;
                }
            }
        } else if (conditional.startsWith("subfieldcontains(")) {
            String[] args = this.getTwoArgs(conditional);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List<Subfield> subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    if (!sf.getData().contains(args[1])) continue;
                    return true;
                }
            } else if (field != null && field instanceof ControlField && args.length == 2 && ((ControlField)field).getData().contains(args[1])) {
                return true;
            }
        } else if (conditional.startsWith("subfieldexists(")) {
            List<Subfield> subfields;
            String arg = this.getOneArg(conditional);
            if (field != null && field instanceof DataField && arg.length() == 1 ? (subfields = ((DataField)field).getSubfields(arg.charAt(0))).size() > 0 : field != null && field instanceof ControlField) {
                return true;
            }
        } else if (conditional.startsWith("and(")) {
            String[] args = this.getTwoConditionals(conditional);
            if (args.length == 2) {
                return this.eval(args[0], field, record) && this.eval(args[1], field, record);
            }
        } else if (conditional.startsWith("or(")) {
            String[] args = this.getTwoConditionals(conditional);
            if (args.length == 2) {
                return this.eval(args[0], field, record) || this.eval(args[1], field, record);
            }
        } else if (conditional.startsWith("fieldexists(")) {
            String[] args = this.getThreeArgs(conditional);
            if (args.length == 3 && args[0].matches("[0-9][0-9][0-9]") && args[1].length() == 1 || args[0].matches("00[1-9]")) {
                for (VariableField vf : record.getVariableFields(args[0])) {
                    ControlField cf;
                    if (vf instanceof DataField) {
                        for (Subfield sf : ((DataField)vf).getSubfields(args[1].charAt(0))) {
                            if (!sf.getData().equals(args[2]) && !sf.getData().matches(args[2])) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!(vf instanceof ControlField) || !(cf = (ControlField)vf).getData().equals(args[2]) && !cf.getData().matches(args[2])) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean process(String command, VariableField field, List<Subfield> sfToDelete, List<VariableField> fToDelete, List<VariableField> fToInsert, Record record) {
        if (command.startsWith("replace(")) {
            String newData;
            String[] args = this.getThreeArgs(command);
            if (field != null && field instanceof DataField && args.length == 3 && args[0].length() == 1) {
                List<Subfield> subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    String newData2 = sf.getData().replaceAll(args[1], args[2]);
                    if (newData2.equals(sf.getData())) continue;
                    sf.setData(newData2);
                }
            } else if (field != null && field instanceof ControlField && args.length == 3 && !(newData = ((ControlField)field).getData().replaceAll(args[1], args[2])).equals(((ControlField)field).getData())) {
                ((ControlField)field).setData(newData);
            }
        } else if (command.startsWith("append(")) {
            String[] args = this.getTwoArgs(command);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List<Subfield> subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    String newData = sf.getData() + args[1];
                    if (newData.equals(sf.getData())) continue;
                    sf.setData(newData);
                }
            } else if (field != null && field instanceof ControlField && args.length == 2) {
                String newData = ((ControlField)field).getData() + args[1];
                ((ControlField)field).setData(newData);
            }
        } else if (command.startsWith("prepend(")) {
            String[] args = this.getTwoArgs(command);
            if (field != null && field instanceof DataField && args.length == 2 && args[0].length() == 1) {
                List<Subfield> subfields = ((DataField)field).getSubfields(args[0].charAt(0));
                for (Subfield sf : subfields) {
                    String newData = args[1] + sf.getData();
                    if (newData.equals(sf.getData())) continue;
                    sf.setData(newData);
                }
            } else if (field != null && field instanceof ControlField && args.length == 2) {
                String newData = args[1] + ((ControlField)field).getData();
                ((ControlField)field).setData(newData);
            }
        } else if (command.startsWith("deletesubfield(")) {
            String arg = this.getOneArg(command);
            if (field != null && field instanceof DataField && arg.length() == 1) {
                List<Subfield> subfields = ((DataField)field).getSubfields(arg.charAt(0));
                for (Subfield sf : subfields) {
                    sfToDelete.add(sf);
                }
            } else if (field != null && field instanceof ControlField) {
                fToDelete.add(field);
            }
        } else if (command.startsWith("both(")) {
            String[] args = this.getTwoConditionals(command);
            boolean returncode = true;
            if (args.length == 2) {
                returncode = this.process(args[0], field, sfToDelete, fToDelete, fToInsert, record);
                returncode &= this.process(args[1], field, sfToDelete, fToDelete, fToInsert, record);
            }
        } else if (command.startsWith("deletefield(")) {
            fToDelete.add(field);
        } else if (command.startsWith("deleteotherfield(")) {
            String[] args = this.getThreeArgs(command);
            if (args.length == 3 && args[0].matches("[0-9][0-9][0-9]") && args[1].length() == 1) {
                for (VariableField vf : record.getVariableFields(args[0])) {
                    List<Subfield> subfields = ((DataField)vf).getSubfields(args[1].charAt(0));
                    for (Subfield sf : subfields) {
                        if (!sf.getData().equals(args[2]) && !sf.getData().matches(args[2])) continue;
                        fToDelete.add(vf);
                    }
                }
            }
        } else if (command.startsWith("insertfield(")) {
            String arg = this.getOneArg(command);
            VariableField vf = this.createFieldFromString(arg, null);
            if (vf != null) {
                fToInsert.add(vf);
            }
        } else if (command.startsWith("movefield(")) {
            String arg = this.getOneArg(command);
            if (arg.length() == 3) {
                field.setTag(arg);
            }
        } else if (command.startsWith("insertparameterizedfield(")) {
            String[] args = this.getThreeArgs(command);
            Pattern p = Pattern.compile(args[2]);
            if (field != null && field instanceof DataField) {
                boolean hadMatch = false;
                List<Subfield> sfs = ((DataField)field).getSubfields(args[1].charAt(0));
                for (Subfield sf : sfs) {
                    Matcher m = p.matcher(sf.getData());
                    if (!m.matches()) continue;
                    hadMatch = true;
                    VariableField vf = this.createFieldFromString(args[0], this.stringsFromMatcher(m));
                    fToInsert.add(0, vf);
                }
                if (!hadMatch) {
                    VariableField variableField = this.createFieldFromString(args[0], null);
                }
            } else {
                Matcher m = p.matcher(((ControlField)field).getData());
                VariableField vf = m.matches() ? this.createFieldFromString(args[0], this.stringsFromMatcher(m)) : this.createFieldFromString(args[0], null);
                if (vf != null) {
                    fToInsert.add(vf);
                }
            }
        } else if (command.startsWith("insertparameterizedsubfield(")) {
            String[] args = this.getFourArgs(command);
            Pattern p = Pattern.compile(args[3]);
            Matcher m = field != null && field instanceof DataField ? p.matcher(((DataField)field).getSubfield(args[2].charAt(0)).getData()) : p.matcher(((ControlField)field).getData());
            VariableField vf = record.getVariableField(args[0]);
            if (m.matches() && vf != null && vf instanceof DataField) {
                vf = this.addSubfieldFromString((DataField)vf, args[1], this.stringsFromMatcher(m), 0);
            } else if (vf != null && vf instanceof DataField) {
                vf = this.addSubfieldFromString((DataField)vf, args[1], null, 0);
            }
        } else if (command.startsWith("appendparameterizedsubfield(")) {
            String[] args = this.getFourArgs(command);
            Pattern p = Pattern.compile(args[3]);
            Matcher m = field != null && field instanceof DataField ? p.matcher(((DataField)field).getSubfield(args[2].charAt(0)).getData()) : p.matcher(((ControlField)field).getData());
            VariableField vf = record.getVariableField(args[0]);
            if (m.matches() && vf != null && vf instanceof DataField) {
                vf = this.addSubfieldFromString((DataField)vf, args[1], this.stringsFromMatcher(m), 1);
            } else if (vf != null && vf instanceof DataField) {
                vf = this.addSubfieldFromString((DataField)vf, args[1], null, 1);
            }
        } else if (command.startsWith("reject()")) {
            return false;
        }
        return true;
    }

    private String[] stringsFromMatcher(Matcher m) {
        String[] result = new String[m.groupCount() + 1];
        result[0] = m.group(0);
        for (int i = 0; i < m.groupCount(); ++i) {
            result[i + 1] = m.group(i + 1);
        }
        return result;
    }

    private VariableField createFieldFromString(String arg, String[] argmatches) {
        Matcher mdf = newDataFieldDef.matcher(arg);
        Matcher cdf = newControlFieldDef.matcher(arg);
        if (factory == null) {
            factory = MarcFactory.newInstance();
        }
        if (cdf.matches()) {
            ControlField cf = factory.newControlField(cdf.group(1));
            String data = cdf.group(2);
            if (argmatches != null) {
                data = this.fillParameters(data, argmatches);
            }
            cf.setData(data);
            return cf;
        }
        if (mdf.matches()) {
            char ind2;
            char ind1 = mdf.group(2).charAt(0);
            if (ind1 < '0' || ind1 > '9') {
                ind1 = ' ';
            }
            if ((ind2 = mdf.group(3).charAt(0)) < '0' || ind2 > '9') {
                ind2 = ' ';
            }
            DataField df = factory.newDataField(mdf.group(1), ind1, ind2);
            String sfData = mdf.group(4);
            while (!sfData.isEmpty()) {
                Matcher sm = newSubfieldDef.matcher(sfData);
                if (!sm.matches()) continue;
                char code = sm.group(1).charAt(0);
                String data = sm.group(2);
                if (argmatches != null) {
                    data = this.fillParameters(data, argmatches);
                }
                sfData = sm.group(4);
                Subfield sf = factory.newSubfield(code, data);
                df.addSubfield(sf);
            }
            return df;
        }
        return null;
    }

    private VariableField addSubfieldFromString(DataField df, String argPattern, String[] argmatches, int zeroForInsert) {
        Matcher sfdf = newSubfieldDef.matcher(argPattern);
        if (factory == null) {
            factory = MarcFactory.newInstance();
        }
        String sfData = argPattern;
        Matcher sm = newSubfieldDef.matcher(argPattern);
        if (sm.matches()) {
            char code = sm.group(1).charAt(0);
            String data = sm.group(2);
            if (argmatches != null) {
                data = this.fillParameters(data, argmatches);
            }
            sfData = sm.group(4);
            Subfield sf = factory.newSubfield(code, data);
            if (zeroForInsert == 0) {
                df.addSubfield(0, sf);
            } else {
                df.addSubfield(sf);
            }
        }
        return df;
    }

    private String fillParameters(String data, String[] argmatches) {
        for (int i = 0; i < argmatches.length; ++i) {
            if (!data.contains("${" + (i + 1) + "}")) continue;
            data = data.replaceAll("[$][{]" + (i + 1) + "[}]", Matcher.quoteReplacement(argmatches[i + 1]));
        }
        return data;
    }

    private String getOneArg(String conditional) {
        Matcher m = oneArg.matcher(conditional.trim());
        if (m.matches()) {
            return m.group(1).replaceAll("\\\"", "\"");
        }
        return null;
    }

    private String[] getTwoArgs(String conditional) {
        Matcher m = twoArgs.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1).replaceAll("\\\"", "\""), m.group(3).replaceAll("\\\"", "\"")};
            return result;
        }
        return null;
    }

    private String[] getThreeArgs(String conditional) {
        Matcher m = threeArgs.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1).replaceAll("\\\"", "\""), m.group(3).replaceAll("\\\"", "\""), m.group(5).replaceAll("\\\"", "\"")};
            return result;
        }
        return null;
    }

    private String[] getFourArgs(String conditional) {
        Matcher m = fourArgs.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1).replaceAll("\\\"", "\""), m.group(3).replaceAll("\\\"", "\""), m.group(5).replaceAll("\\\"", "\""), m.group(7).replaceAll("\\\"", "\"")};
            return result;
        }
        return null;
    }

    private String[] getTwoConditionals(String conditional) {
        Matcher m = twoConditionals.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1), m.group(2)};
            return result;
        }
        return null;
    }

    private String getOneConditional(String conditional) {
        Matcher m = oneConditional.matcher(conditional.trim());
        if (m.matches()) {
            String result = m.group(1);
            return result;
        }
        return null;
    }

    private String[] getArgAndConditional(String conditional) {
        Matcher m = argAndConditional.matcher(conditional.trim());
        if (m.matches()) {
            String[] result = new String[]{m.group(1), m.group(2)};
            return result;
        }
        return null;
    }
}

