/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.QualifierSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;

public final class LifecycleCallbackFactory {
    private LifecycleCallbackFactory() {
    }

    public static List<LifecycleCallbackMethodReference> beforeMappingMethods(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx) {
        return LifecycleCallbackFactory.collectLifecycleCallbackMethods(method, selectionParameters, LifecycleCallbackFactory.filterBeforeMappingMethods(ctx.getSourceModel()), ctx);
    }

    public static List<LifecycleCallbackMethodReference> afterMappingMethods(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx) {
        return LifecycleCallbackFactory.collectLifecycleCallbackMethods(method, selectionParameters, LifecycleCallbackFactory.filterAfterMappingMethods(ctx.getSourceModel()), ctx);
    }

    private static List<LifecycleCallbackMethodReference> collectLifecycleCallbackMethods(Method method, SelectionParameters selectionParameters, List<SourceMethod> callbackMethods, MappingBuilderContext ctx) {
        HashMap<SourceMethod, List<Parameter>> parameterAssignmentsForSourceMethod = new HashMap<SourceMethod, List<Parameter>>();
        List<SourceMethod> candidates = LifecycleCallbackFactory.filterCandidatesByType(method, callbackMethods, parameterAssignmentsForSourceMethod, ctx);
        candidates = LifecycleCallbackFactory.filterCandidatesByQualifiers(method, selectionParameters, candidates, ctx);
        return LifecycleCallbackFactory.toLifecycleCallbackMethodRefs(candidates, parameterAssignmentsForSourceMethod, ctx);
    }

    private static List<SourceMethod> filterCandidatesByQualifiers(Method method, SelectionParameters selectionParameters, List<SourceMethod> candidates, MappingBuilderContext ctx) {
        QualifierSelector selector = new QualifierSelector(ctx.getTypeUtils(), ctx.getElementUtils());
        return selector.getMatchingMethods(method, candidates, null, null, new SelectionCriteria(selectionParameters, null, false));
    }

    private static List<LifecycleCallbackMethodReference> toLifecycleCallbackMethodRefs(List<SourceMethod> candidates, Map<SourceMethod, List<Parameter>> parameterAssignmentsForSourceMethod, MappingBuilderContext ctx) {
        ArrayList<LifecycleCallbackMethodReference> result = new ArrayList<LifecycleCallbackMethodReference>();
        for (SourceMethod candidate : candidates) {
            LifecycleCallbackFactory.markMapperReferenceAsUsed(ctx.getMapperReferences(), candidate);
            result.add(new LifecycleCallbackMethodReference(candidate, parameterAssignmentsForSourceMethod.get(candidate)));
        }
        return result;
    }

    private static List<SourceMethod> filterCandidatesByType(Method method, List<SourceMethod> callbackMethods, Map<SourceMethod, List<Parameter>> parameterAssignmentsForSourceMethod, MappingBuilderContext ctx) {
        ArrayList<SourceMethod> candidates = new ArrayList<SourceMethod>();
        List<Parameter> availableParams = LifecycleCallbackFactory.getAvailableParameters(method, ctx);
        for (SourceMethod callback : callbackMethods) {
            List<Parameter> parameterAssignments = LifecycleCallbackFactory.getParameterAssignments(availableParams, callback.getParameters());
            if (parameterAssignments == null || !callback.matches(LifecycleCallbackFactory.extractSourceTypes(parameterAssignments), method.getResultType())) continue;
            parameterAssignmentsForSourceMethod.put(callback, parameterAssignments);
            candidates.add(callback);
        }
        return candidates;
    }

    private static List<Parameter> getAvailableParameters(Method method, MappingBuilderContext ctx) {
        ArrayList<Parameter> availableParams = new ArrayList<Parameter>(method.getParameters());
        if (method.getMappingTargetParameter() == null) {
            availableParams.add(new Parameter(null, method.getResultType(), true, false));
        }
        Parameter targetTypeParameter = new Parameter(null, ctx.getTypeFactory().classTypeOf(method.getResultType()), false, true);
        availableParams.add(targetTypeParameter);
        return availableParams;
    }

    private static void markMapperReferenceAsUsed(List<MapperReference> references, Method method) {
        for (MapperReference ref : references) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            ref.setUsed(!method.isStatic());
            ref.setTypeRequiresImport(true);
            return;
        }
    }

    private static List<Type> extractSourceTypes(List<Parameter> parameters) {
        ArrayList<Type> result = new ArrayList<Type>(parameters.size());
        for (Parameter param : parameters) {
            if (param.isMappingTarget() || param.isTargetType()) continue;
            result.add(param.getType());
        }
        return result;
    }

    private static List<Parameter> getParameterAssignments(List<Parameter> availableParams, List<Parameter> methodParameters) {
        ArrayList<Parameter> result = new ArrayList<Parameter>(methodParameters.size());
        for (Parameter methodParam : methodParameters) {
            List<Parameter> assignableParams = LifecycleCallbackFactory.findCandidateParameters(availableParams, methodParam);
            if (assignableParams.isEmpty()) {
                return null;
            }
            if (assignableParams.size() == 1) {
                result.add(assignableParams.get(0));
                continue;
            }
            if (assignableParams.size() <= 1) continue;
            Parameter paramWithMatchingName = LifecycleCallbackFactory.findParameterWithName(assignableParams, methodParam.getName());
            if (paramWithMatchingName != null) {
                result.add(paramWithMatchingName);
                continue;
            }
            return null;
        }
        return result;
    }

    private static Parameter findParameterWithName(List<Parameter> parameters, String name) {
        for (Parameter param : parameters) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    private static List<Parameter> findCandidateParameters(List<Parameter> candiateParameters, Parameter parameter) {
        ArrayList<Parameter> result = new ArrayList<Parameter>(candiateParameters.size());
        for (Parameter candidate : candiateParameters) {
            if ((LifecycleCallbackFactory.isTypeVarOrWildcard(parameter) || candidate.getType().isAssignableTo(parameter.getType())) && parameter.isMappingTarget() == candidate.isMappingTarget() && !parameter.isTargetType() && !candidate.isTargetType()) {
                result.add(candidate);
                continue;
            }
            if (!parameter.isTargetType() || !candidate.isTargetType()) continue;
            result.add(candidate);
        }
        return result;
    }

    private static boolean isTypeVarOrWildcard(Parameter parameter) {
        TypeKind kind = parameter.getType().getTypeMirror().getKind();
        return kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD;
    }

    private static List<SourceMethod> filterBeforeMappingMethods(List<SourceMethod> methods) {
        ArrayList<SourceMethod> result = new ArrayList<SourceMethod>();
        for (SourceMethod method : methods) {
            if (!method.isBeforeMappingMethod()) continue;
            result.add(method);
        }
        return result;
    }

    private static List<SourceMethod> filterAfterMappingMethods(List<SourceMethod> methods) {
        ArrayList<SourceMethod> result = new ArrayList<SourceMethod>();
        for (SourceMethod method : methods) {
            if (!method.isAfterMappingMethod()) continue;
            result.add(method);
        }
        return result;
    }
}

