/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.CreateView;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.ForceOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.TemporaryOption;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class CreateViewValidator
extends AbstractValidator<CreateView> {
    @Override
    public void validate(CreateView createView) {
        for (ValidationCapability object2 : this.getCapabilities()) {
            this.validateFeature(object2, Feature.createView);
            this.validateFeature(object2, createView.isOrReplace(), Feature.createOrReplaceView);
            this.validateFeature(object2, !ForceOption.NONE.equals((Object)createView.getForce()), Feature.createViewForce);
            this.validateFeature(object2, !TemporaryOption.NONE.equals((Object)createView.getTemporary()), Feature.createViewTemporary);
            this.validateFeature(object2, createView.isMaterialized(), Feature.createViewMaterialized);
            this.validateName(object2, NamedObject.view, createView.getView().getFullyQualifiedName(), false, new NamedObject[0]);
        }
        SelectValidator selectValidator = this.getValidator(SelectValidator.class);
        Select select = createView.getSelect();
        if (this.isNotEmpty(select.getWithItemsList())) {
            select.getWithItemsList().forEach(withItem -> withItem.accept(selectValidator));
        }
        select.getSelectBody().accept(selectValidator);
    }
}

