/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.bootstrapfx.scene.layout;

import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

@DefaultProperty(value="body")
public class Panel
extends BorderPane {
    private ObjectProperty<Node> heading;
    private ObjectProperty<Node> body;
    private ObjectProperty<Node> footer;

    public Panel() {
        this.getStyleClass().setAll((Object[])new String[]{"panel"});
    }

    public Panel(String title) {
        this();
        this.setText(title);
    }

    public final ObjectProperty<Node> headingProperty() {
        if (this.heading == null) {
            this.heading = new SimpleObjectProperty((Object)this, "heading");
            this.heading.addListener((v, o, n) -> {
                if (null != n) {
                    GridPane box = new GridPane();
                    box.getStyleClass().setAll((Object[])new String[]{"panel-heading"});
                    GridPane.setColumnIndex((Node)n, (Integer)0);
                    GridPane.setRowIndex((Node)n, (Integer)0);
                    GridPane.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                    GridPane.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                    box.getChildren().add(n);
                    this.setTop((Node)box);
                }
            });
        }
        return this.heading;
    }

    public final void setHeading(Node content) {
        this.headingProperty().set((Object)content);
    }

    public final Node getHeading() {
        return this.heading == null ? null : (Node)this.heading.get();
    }

    public final ObjectProperty<Node> bodyProperty() {
        if (this.body == null) {
            this.body = new SimpleObjectProperty((Object)this, "body");
            this.body.addListener((v, o, n) -> {
                if (null != n) {
                    GridPane box = new GridPane();
                    box.getStyleClass().setAll((Object[])new String[]{"panel-body"});
                    GridPane.setColumnIndex((Node)n, (Integer)0);
                    GridPane.setRowIndex((Node)n, (Integer)0);
                    GridPane.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                    GridPane.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                    box.getChildren().add(n);
                    this.setCenter((Node)box);
                }
            });
        }
        return this.body;
    }

    public final void setBody(Node body) {
        this.bodyProperty().set((Object)body);
    }

    public final Node getBody() {
        return this.body == null ? null : (Node)this.body.get();
    }

    public final ObjectProperty<Node> footerProperty() {
        if (this.footer == null) {
            this.footer = new SimpleObjectProperty((Object)this, "footer");
            this.footer.addListener((v, o, n) -> {
                if (null != n) {
                    GridPane box = new GridPane();
                    box.getStyleClass().setAll((Object[])new String[]{"panel-footer"});
                    GridPane.setColumnIndex((Node)n, (Integer)0);
                    GridPane.setRowIndex((Node)n, (Integer)0);
                    GridPane.setHgrow((Node)n, (Priority)Priority.ALWAYS);
                    GridPane.setVgrow((Node)n, (Priority)Priority.ALWAYS);
                    box.getChildren().add(n);
                    this.setBottom((Node)box);
                }
            });
        }
        return this.footer;
    }

    public final void setFooter(Node content) {
        this.footerProperty().set((Object)content);
    }

    public final Node getFooter() {
        return this.footer == null ? null : (Node)this.footer.get();
    }

    public void setText(String text) {
        Label label = new Label(text);
        label.getStyleClass().add((Object)"panel-title");
        this.headingProperty().set((Object)label);
    }

    public String getText() {
        Node node = (Node)this.headingProperty().get();
        if (node instanceof Labeled) {
            return ((Labeled)node).getText();
        }
        return null;
    }
}

