/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import jodd.log.Logger;
import jodd.log.LoggerFactoryInterface;
import jodd.log.impl.SimpleLogger;

public class SimpleLoggerFactory
implements LoggerFactoryInterface {
    private final Logger.Level globalLevel;
    private final long startTime;

    public SimpleLoggerFactory(Logger.Level globalLevel) {
        this.globalLevel = globalLevel;
        this.startTime = System.currentTimeMillis();
    }

    public Logger.Level getLevel() {
        return this.globalLevel;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public Logger getLogger(String name) {
        return new SimpleLogger(this, name);
    }

    protected String getCallerClass() {
        StackTraceElement[] stackTrace;
        Exception exception = new Exception();
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            String className = stackTraceElement.getClassName();
            if (className.equals(SimpleLoggerFactory.class.getName()) || className.equals(SimpleLogger.class.getName())) continue;
            return this.shortenClassName(className) + '.' + stackTraceElement.getMethodName() + ':' + stackTraceElement.getLineNumber();
        }
        return "N/A";
    }

    protected String shortenClassName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return className;
        }
        StringBuilder shortClassName = new StringBuilder(className.length());
        int start = 0;
        while (true) {
            shortClassName.append(className.charAt(start));
            int next = className.indexOf(46, start);
            if (next == lastDotIndex) break;
            start = next + 1;
            shortClassName.append('.');
        }
        shortClassName.append(className.substring(lastDotIndex));
        return shortClassName.toString();
    }
}

