/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.net;

import java.io.ByteArrayOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.core.JoddCore;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public class URLCoder {
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String HTTP_PATTERN = "(http|https):";
    private static final String USERINFO_PATTERN = "([^@/]*)";
    private static final String HOST_PATTERN = "([^/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(http|https):(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?(.*))?");

    private static String encodeUriComponent(String source, String encoding, URIPart uriPart) {
        if (source == null) {
            return null;
        }
        byte[] bytes = URLCoder.encodeBytes(StringUtil.getBytes(source, encoding), uriPart);
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return new String(chars);
    }

    private static byte[] encodeBytes(byte[] source, URIPart uriPart) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);
        for (byte b : source) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (uriPart.isValid((char)b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        return bos.toByteArray();
    }

    public static String encode(String string, String encoding) {
        return URLCoder.encodeUriComponent(string, encoding, URIPart.UNRESERVED);
    }

    public static String encode(String string) {
        return URLCoder.encodeUriComponent(string, JoddCore.get().defaults().getEncoding(), URIPart.UNRESERVED);
    }

    public static String encodeScheme(String scheme, String encoding) {
        return URLCoder.encodeUriComponent(scheme, encoding, URIPart.SCHEME);
    }

    public static String encodeScheme(String scheme) {
        return URLCoder.encodeUriComponent(scheme, JoddCore.get().defaults().getEncoding(), URIPart.SCHEME);
    }

    public static String encodeUserInfo(String userInfo, String encoding) {
        return URLCoder.encodeUriComponent(userInfo, encoding, URIPart.USER_INFO);
    }

    public static String encodeUserInfo(String userInfo) {
        return URLCoder.encodeUriComponent(userInfo, JoddCore.get().defaults().getEncoding(), URIPart.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) {
        return URLCoder.encodeUriComponent(host, encoding, URIPart.HOST);
    }

    public static String encodeHost(String host) {
        return URLCoder.encodeUriComponent(host, JoddCore.get().defaults().getEncoding(), URIPart.HOST);
    }

    public static String encodePort(String port, String encoding) {
        return URLCoder.encodeUriComponent(port, encoding, URIPart.PORT);
    }

    public static String encodePort(String port) {
        return URLCoder.encodeUriComponent(port, JoddCore.get().defaults().getEncoding(), URIPart.PORT);
    }

    public static String encodePath(String path, String encoding) {
        return URLCoder.encodeUriComponent(path, encoding, URIPart.PATH);
    }

    public static String encodePath(String path) {
        return URLCoder.encodeUriComponent(path, JoddCore.get().defaults().getEncoding(), URIPart.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) {
        return URLCoder.encodeUriComponent(segment, encoding, URIPart.PATH_SEGMENT);
    }

    public static String encodePathSegment(String segment) {
        return URLCoder.encodeUriComponent(segment, JoddCore.get().defaults().getEncoding(), URIPart.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) {
        return URLCoder.encodeUriComponent(query, encoding, URIPart.QUERY);
    }

    public static String encodeQuery(String query) {
        return URLCoder.encodeUriComponent(query, JoddCore.get().defaults().getEncoding(), URIPart.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) {
        return URLCoder.encodeUriComponent(queryParam, encoding, URIPart.QUERY_PARAM);
    }

    public static String encodeQueryParam(String queryParam) {
        return URLCoder.encodeUriComponent(queryParam, JoddCore.get().defaults().getEncoding(), URIPart.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) {
        return URLCoder.encodeUriComponent(fragment, encoding, URIPart.FRAGMENT);
    }

    public static String encodeFragment(String fragment) {
        return URLCoder.encodeUriComponent(fragment, JoddCore.get().defaults().getEncoding(), URIPart.FRAGMENT);
    }

    public static String encodeUri(String uri) {
        return URLCoder.encodeUri(uri, JoddCore.get().defaults().getEncoding());
    }

    public static String encodeUri(String uri, String encoding) {
        Matcher m = URI_PATTERN.matcher(uri);
        if (m.matches()) {
            String scheme = m.group(2);
            String authority = m.group(3);
            String userinfo = m.group(5);
            String host = m.group(6);
            String port = m.group(8);
            String path = m.group(9);
            String query = m.group(11);
            String fragment = m.group(13);
            return URLCoder.encodeUriComponents(scheme, authority, userinfo, host, port, path, query, fragment, encoding);
        }
        throw new IllegalArgumentException("Invalid URI: " + uri);
    }

    public static String encodeHttpUrl(String httpUrl) {
        return URLCoder.encodeHttpUrl(httpUrl, JoddCore.get().defaults().getEncoding());
    }

    public static String encodeHttpUrl(String httpUrl, String encoding) {
        Matcher m = HTTP_URL_PATTERN.matcher(httpUrl);
        if (m.matches()) {
            String scheme = m.group(1);
            String authority = m.group(2);
            String userinfo = m.group(4);
            String host = m.group(5);
            String portString = m.group(7);
            String path = m.group(8);
            String query = m.group(10);
            return URLCoder.encodeUriComponents(scheme, authority, userinfo, host, portString, path, query, null, encoding);
        }
        throw new IllegalArgumentException("Invalid HTTP URL: " + httpUrl);
    }

    private static String encodeUriComponents(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String encoding) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(URLCoder.encodeScheme(scheme, encoding));
            sb.append(':');
        }
        if (authority != null) {
            sb.append("//");
            if (userInfo != null) {
                sb.append(URLCoder.encodeUserInfo(userInfo, encoding));
                sb.append('@');
            }
            if (host != null) {
                sb.append(URLCoder.encodeHost(host, encoding));
            }
            if (port != null) {
                sb.append(':');
                sb.append(URLCoder.encodePort(port, encoding));
            }
        }
        sb.append(URLCoder.encodePath(path, encoding));
        if (query != null) {
            sb.append('?');
            sb.append(URLCoder.encodeQuery(query, encoding));
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(URLCoder.encodeFragment(fragment, encoding));
        }
        return sb.toString();
    }

    public static Builder build(String path) {
        return URLCoder.build(path, true);
    }

    public static Builder build(String path, boolean encodePath) {
        return new Builder(path, encodePath, JoddCore.get().defaults().getEncoding());
    }

    public static class Builder {
        protected final StringBuilder url;
        protected final String encoding;
        protected boolean hasParams;

        public Builder(String path, boolean encodePath, String encoding) {
            this.encoding = encoding;
            this.url = new StringBuilder();
            if (encodePath) {
                this.url.append(URLCoder.encodeUri(path, encoding));
            } else {
                this.url.append(path);
            }
            this.hasParams = this.url.indexOf("?") != -1;
        }

        public Builder queryParam(String name, String value) {
            this.url.append(this.hasParams ? (char)'&' : '?');
            this.hasParams = true;
            this.url.append(URLCoder.encodeQueryParam(name, this.encoding));
            if (value != null && value.length() > 0) {
                this.url.append('=');
                this.url.append(URLCoder.encodeQueryParam(value, this.encoding));
            }
            return this;
        }

        public String toString() {
            return this.url.toString();
        }
    }

    static enum URIPart {
        UNRESERVED{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isUnreserved(c);
            }
        }
        ,
        SCHEME{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isAlpha(c) || CharUtil.isDigit(c) || c == '+' || c == '-' || c == '.';
            }
        }
        ,
        USER_INFO{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isUnreserved(c) || CharUtil.isSubDelimiter(c) || c == ':';
            }
        }
        ,
        HOST{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isUnreserved(c) || CharUtil.isSubDelimiter(c);
            }
        }
        ,
        PORT{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isDigit(c);
            }
        }
        ,
        PATH{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isPchar(c) || c == '/';
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isPchar(c) || c == '/' || c == '?';
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isValid(char c) {
                if (c == '=' || c == '+' || c == '&' || c == ';') {
                    return false;
                }
                return CharUtil.isPchar(c) || c == '/' || c == '?';
            }
        }
        ,
        FRAGMENT{

            @Override
            public boolean isValid(char c) {
                return CharUtil.isPchar(c) || c == '/' || c == '?';
            }
        };


        public abstract boolean isValid(char var1);
    }
}

