/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.jetlinks.reactor.ql.supports.DefaultPropertyFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class CastUtils {
    public static <T> Flux<T> handleFirst(Flux<?> stream, BiFunction<Object, Flux<?>, Publisher<T>> handler) {
        return stream.switchOnFirst((signal, objectFlux) -> {
            if (!signal.hasValue()) {
                return Mono.empty();
            }
            Object first = signal.get();
            return (Publisher)handler.apply(first, (Flux<?>)objectFlux);
        });
    }

    public static Flux<Object> flatStream(Flux<?> stream) {
        return stream.flatMap(val -> {
            if (val instanceof Object[]) {
                return Flux.just((Object[])((Object[])val));
            }
            if (val instanceof Iterable) {
                return Flux.fromIterable((Iterable)((Iterable)val));
            }
            if (val instanceof Publisher) {
                return Flux.from((Publisher)((Publisher)val));
            }
            return Flux.just((Object)val);
        });
    }

    public static boolean castBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String strVal = String.valueOf(value);
        return "true".equalsIgnoreCase(strVal) || "y".equalsIgnoreCase(strVal) || "ok".equalsIgnoreCase(strVal) || "yes".equalsIgnoreCase(strVal) || "1".equalsIgnoreCase(strVal);
    }

    public static Map<Object, Object> castMap(List<Object> list) {
        return CastUtils.castMap(list, Function.identity(), Function.identity());
    }

    public static <K, V> Map<K, V> castMap(List<Object> list, Function<Object, K> keyMapper, Function<Object, V> valueMapper) {
        int size = list.size();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(size);
        for (int i = 0; i < size / 2; ++i) {
            map.put(keyMapper.apply(list.get(i * 2)), valueMapper.apply(list.get(i * 2 + 1)));
        }
        return map;
    }

    public static Set<Object> castSet(Object value) {
        return new HashSet<Object>(CastUtils.castArray(value));
    }

    public static List<Object> castArray(Object value) {
        if (value instanceof Collection) {
            return new ArrayList<Object>((Collection)value);
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    public static String castString(Object val) {
        if (val instanceof byte[]) {
            return new String((byte[])val);
        }
        if (val instanceof char[]) {
            return new String((char[])val);
        }
        return String.valueOf(val);
    }

    public static Number castNumber(Object value, Function<Integer, Number> integerMapper, Function<Long, Number> longMapper, Function<Double, Number> doubleMapper, Function<Float, Number> floatMapper, Function<Number, Number> defaultMapper) {
        Number number = CastUtils.castNumber(value);
        if (number instanceof Integer) {
            return integerMapper.apply((Integer)number);
        }
        if (number instanceof Long) {
            return longMapper.apply((Long)number);
        }
        if (number instanceof Double) {
            return doubleMapper.apply((Double)number);
        }
        if (number instanceof Float) {
            return floatMapper.apply((Float)number);
        }
        return defaultMapper.apply(number);
    }

    public static Number castNumber(Object value) {
        if (value instanceof CharSequence) {
            String stringValue = String.valueOf(value);
            if (stringValue.startsWith("0x")) {
                return Long.parseLong(stringValue.substring(2), 16);
            }
            try {
                BigDecimal decimal = new BigDecimal(stringValue);
                if (decimal.scale() == 0) {
                    return decimal.longValue();
                }
                return decimal.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Character) {
            return (int)((Character)value).charValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        try {
            return CastUtils.castDate(value).getTime();
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException("can not cast to number:" + value);
        }
    }

    public static Date castDate(Object value) {
        if (value instanceof String) {
            if (StringUtils.isNumber((Object)value)) {
                value = Long.parseLong(String.valueOf(value));
            } else {
                String maybeTimeValue = String.valueOf(value);
                if (maybeTimeValue.length() == 8 && maybeTimeValue.contains(":")) {
                    value = LocalTime.parse(maybeTimeValue);
                } else {
                    Date date;
                    LocalDateTime time = LocalDateTime.now();
                    if (maybeTimeValue.contains("yyyy")) {
                        maybeTimeValue = maybeTimeValue.replace("yyyy", String.valueOf(time.getYear()));
                    }
                    if (maybeTimeValue.contains("MM")) {
                        maybeTimeValue = maybeTimeValue.replace("MM", String.valueOf(time.getMonthValue()));
                    }
                    if (maybeTimeValue.contains("dd")) {
                        maybeTimeValue = maybeTimeValue.replace("dd", String.valueOf(time.getDayOfMonth()));
                    }
                    if (maybeTimeValue.contains("hh")) {
                        maybeTimeValue = maybeTimeValue.replace("hh", String.valueOf(time.getHour()));
                    }
                    if (maybeTimeValue.contains("mm")) {
                        maybeTimeValue = maybeTimeValue.replace("mm", String.valueOf(time.getMinute()));
                    }
                    if (maybeTimeValue.contains("ss")) {
                        maybeTimeValue = maybeTimeValue.replace("ss", String.valueOf(time.getSecond()));
                    }
                    if (null != (date = DateFormatter.fromString((String)maybeTimeValue))) {
                        return date;
                    }
                }
            }
        }
        if (value instanceof LocalTime) {
            value = LocalDateTime.of(LocalDate.now(), (LocalTime)value);
        }
        if (value instanceof LocalDate) {
            value = LocalDateTime.of((LocalDate)value, LocalTime.MIN);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof Instant) {
            value = Date.from((Instant)value);
        }
        if (value instanceof LocalDateTime) {
            value = Timestamp.valueOf((LocalDateTime)value);
        }
        if (value instanceof ZonedDateTime) {
            value = Date.from(((ZonedDateTime)value).toInstant());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new UnsupportedOperationException("can not cast to date:" + value);
    }

    public static Duration parseDuration(String timeString) {
        char[] all = timeString.replace("ms", "S").toCharArray();
        if (all[0] == 'P' || all[0] == '-' && all[1] == 'P') {
            return Duration.parse(timeString);
        }
        Duration duration = Duration.ofSeconds(0L);
        char[] tmp = new char[32];
        int numIndex = 0;
        for (char c : all) {
            if (c == '-' || c >= '0' && c <= '9') {
                tmp[numIndex++] = c;
                continue;
            }
            long val = new BigDecimal(tmp, 0, numIndex).longValue();
            numIndex = 0;
            Duration plus = null;
            if (c == 'D' || c == 'd') {
                plus = Duration.ofDays(val);
            } else if (c == 'H' || c == 'h') {
                plus = Duration.ofHours(val);
            } else if (c == 'M' || c == 'm') {
                plus = Duration.ofMinutes(val);
            } else if (c == 's') {
                plus = Duration.ofSeconds(val);
            } else if (c == 'S') {
                plus = Duration.ofMillis(val);
            } else if (c == 'W' || c == 'w') {
                plus = Duration.ofDays(val * 7L);
            }
            if (plus == null) continue;
            duration = duration.plus(plus);
        }
        return duration;
    }

    public static Object tryGetFirstValue(Object value) {
        if (value instanceof Map && ((Map)value).size() > 0) {
            return ((Map)value).values().iterator().next();
        }
        if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return value;
    }

    public static Optional<Object> tryGetFirstValueOptional(Object value) {
        return Optional.ofNullable(CastUtils.tryGetFirstValue(value));
    }

    public static Map<Object, Object> listToMap(Collection<Object> values, Object keyField, Object valueField) {
        return values.stream().map(obj -> {
            Object keyVal = DefaultPropertyFeature.GLOBAL.getProperty(keyField, obj).orElse(null);
            Object value = DefaultPropertyFeature.GLOBAL.getProperty(valueField, obj).orElse(null);
            if (keyVal == null || value == null) {
                return null;
            }
            return Tuples.of(keyVal, value);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
    }
}

