/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.supports.DefaultPropertyFeature;
import org.jetlinks.reactor.ql.supports.agg.CollectListAggFeature;
import org.jetlinks.reactor.ql.supports.agg.CollectRowAggMapFeature;
import org.jetlinks.reactor.ql.supports.agg.CountAggFeature;
import org.jetlinks.reactor.ql.supports.agg.MapAggFeature;
import org.jetlinks.reactor.ql.supports.distinct.DefaultDistinctFeature;
import org.jetlinks.reactor.ql.supports.filter.AndFilter;
import org.jetlinks.reactor.ql.supports.filter.BetweenFilter;
import org.jetlinks.reactor.ql.supports.filter.EqualsFilter;
import org.jetlinks.reactor.ql.supports.filter.GreaterEqualsTanFilter;
import org.jetlinks.reactor.ql.supports.filter.GreaterTanFilter;
import org.jetlinks.reactor.ql.supports.filter.IfValueMapFeature;
import org.jetlinks.reactor.ql.supports.filter.InFilter;
import org.jetlinks.reactor.ql.supports.filter.LessEqualsTanFilter;
import org.jetlinks.reactor.ql.supports.filter.LessTanFilter;
import org.jetlinks.reactor.ql.supports.filter.LikeFilter;
import org.jetlinks.reactor.ql.supports.filter.OrFilter;
import org.jetlinks.reactor.ql.supports.fmap.ArrayValueFlatMapFeature;
import org.jetlinks.reactor.ql.supports.from.FromTableFeature;
import org.jetlinks.reactor.ql.supports.from.FromValuesFeature;
import org.jetlinks.reactor.ql.supports.from.SubSelectFromFeature;
import org.jetlinks.reactor.ql.supports.from.ZipSelectFeature;
import org.jetlinks.reactor.ql.supports.group.GroupByCalculateBinaryFeature;
import org.jetlinks.reactor.ql.supports.group.GroupByIntervalFeature;
import org.jetlinks.reactor.ql.supports.group.GroupByTakeFeature;
import org.jetlinks.reactor.ql.supports.group.GroupByValueFeature;
import org.jetlinks.reactor.ql.supports.group.GroupByWindowFeature;
import org.jetlinks.reactor.ql.supports.group.TraceGroupRowFeature;
import org.jetlinks.reactor.ql.supports.map.BinaryCalculateMapFeature;
import org.jetlinks.reactor.ql.supports.map.BinaryMapFeature;
import org.jetlinks.reactor.ql.supports.map.CaseMapFeature;
import org.jetlinks.reactor.ql.supports.map.CastFeature;
import org.jetlinks.reactor.ql.supports.map.CoalesceMapFeature;
import org.jetlinks.reactor.ql.supports.map.DateFormatFeature;
import org.jetlinks.reactor.ql.supports.map.FunctionMapFeature;
import org.jetlinks.reactor.ql.supports.map.NowFeature;
import org.jetlinks.reactor.ql.supports.map.PropertyMapFeature;
import org.jetlinks.reactor.ql.supports.map.SelectFeature;
import org.jetlinks.reactor.ql.supports.map.SingleParameterFunctionMapFeature;
import org.jetlinks.reactor.ql.utils.CalculateUtils;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.reactor.ql.utils.CompareUtils;
import org.reactivestreams.Publisher;
import reactor.bool.BooleanUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.math.MathFlux;

public class DefaultReactorQLMetadata
implements ReactorQLMetadata {
    private static final Map<String, Feature> globalFeatures = new ConcurrentHashMap<String, Feature>();
    private PlainSelect selectSql;
    private Map<String, Feature> features = null;
    private Map<String, Object> settings = null;

    static <T> void createCalculator(BiFunction<String, BiFunction<Number, Number, Object>, T> builder, Consumer<T> consumer) {
        consumer.accept(builder.apply("+", CalculateUtils::add));
        consumer.accept(builder.apply("-", CalculateUtils::subtract));
        consumer.accept(builder.apply("*", CalculateUtils::multiply));
        consumer.accept(builder.apply("/", CalculateUtils::division));
        consumer.accept(builder.apply("%", CalculateUtils::mod));
        consumer.accept(builder.apply("&", CalculateUtils::bitAnd));
        consumer.accept(builder.apply("|", CalculateUtils::bitOr));
        consumer.accept(builder.apply("^", CalculateUtils::bitMutex));
        consumer.accept(builder.apply("<<", CalculateUtils::leftShift));
        consumer.accept(builder.apply(">>", CalculateUtils::rightShift));
        consumer.accept(builder.apply(">>>", CalculateUtils::unsignedRightShift));
        consumer.accept(builder.apply("bit_left_shift", CalculateUtils::leftShift));
        consumer.accept(builder.apply("bit_right_shift", CalculateUtils::rightShift));
        consumer.accept(builder.apply("bit_unsigned_shift", CalculateUtils::unsignedRightShift));
        consumer.accept(builder.apply("bit_and", CalculateUtils::bitAnd));
        consumer.accept(builder.apply("bit_or", CalculateUtils::bitOr));
        consumer.accept(builder.apply("bit_mutex", CalculateUtils::bitMutex));
        consumer.accept(builder.apply("math.plus", CalculateUtils::add));
        consumer.accept(builder.apply("math.sub", CalculateUtils::subtract));
        consumer.accept(builder.apply("math.mul", CalculateUtils::multiply));
        consumer.accept(builder.apply("math.divi", CalculateUtils::division));
        consumer.accept(builder.apply("math.mod", CalculateUtils::mod));
        consumer.accept(builder.apply("math.atan2", (v1, v2) -> Math.atan2(v1.doubleValue(), v2.doubleValue())));
        consumer.accept(builder.apply("math.ieee_rem", (v1, v2) -> Math.IEEEremainder(v1.doubleValue(), v2.doubleValue())));
        consumer.accept(builder.apply("math.copy_sign", (v1, v2) -> Math.copySign(v1.doubleValue(), v2.doubleValue())));
    }

    public static void addGlobal(Feature feature) {
        globalFeatures.put(feature.getId().toLowerCase(), feature);
    }

    private void init() {
        if (this.selectSql.getOracleHint() != null) {
            String[] arr;
            String settings = this.selectSql.getOracleHint().getValue();
            for (String set : arr = settings.split(",")) {
                if (!(set = set.trim().replace("\n", "")).contains("(")) {
                    this.settings().put(set, true);
                    continue;
                }
                this.settings().put(set.substring(0, set.indexOf("(")), set.substring(set.indexOf("(") + 1, set.length() - 1));
            }
        }
    }

    private synchronized Map<String, Object> settings() {
        return this.settings == null ? (this.settings = new ConcurrentHashMap<String, Object>()) : this.settings;
    }

    private synchronized Map<String, Feature> features() {
        return this.features == null ? (this.features = new ConcurrentHashMap<String, Feature>()) : this.features;
    }

    public DefaultReactorQLMetadata(String sql) {
        this.selectSql = (PlainSelect)((Select)CCJSqlParserUtil.parse((String)sql)).getSelectBody();
        this.init();
    }

    public DefaultReactorQLMetadata(PlainSelect selectSql) {
        this.selectSql = selectSql;
        this.init();
    }

    @Override
    public <T extends Feature> Optional<T> getFeature(FeatureId<T> featureId) {
        Feature feature;
        String id = featureId.getId().toLowerCase();
        Feature feature2 = feature = this.features == null ? null : this.features.get(id);
        if (feature == null) {
            feature = globalFeatures.get(id);
        }
        return Optional.ofNullable(feature);
    }

    public void addFeature(Feature ... features) {
        this.addFeature(Arrays.asList(features));
    }

    public void addFeature(Collection<Feature> features) {
        for (Feature feature : features) {
            this.features().put(feature.getId().toLowerCase(), feature);
        }
    }

    @Override
    public PlainSelect getSql() {
        if (this.selectSql == null) {
            throw new IllegalStateException("sql released");
        }
        return this.selectSql;
    }

    @Override
    public void release() {
        this.selectSql = null;
    }

    @Override
    public ReactorQLMetadata setting(String key, Object value) {
        this.settings().put(key, value);
        return this;
    }

    @Override
    public Optional<Object> getSetting(String key) {
        if (this.settings == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.settings.get(key));
    }

    static {
        DefaultReactorQLMetadata.addGlobal(new DefaultDistinctFeature());
        DefaultReactorQLMetadata.addGlobal(new SubSelectFromFeature());
        DefaultReactorQLMetadata.addGlobal(new FromTableFeature());
        DefaultReactorQLMetadata.addGlobal(new ZipSelectFeature());
        DefaultReactorQLMetadata.addGlobal(new FromValuesFeature());
        DefaultReactorQLMetadata.addGlobal(new CollectListAggFeature());
        DefaultReactorQLMetadata.addGlobal(DefaultPropertyFeature.GLOBAL);
        DefaultReactorQLMetadata.addGlobal(new PropertyMapFeature());
        DefaultReactorQLMetadata.addGlobal(new CountAggFeature());
        DefaultReactorQLMetadata.addGlobal(new CaseMapFeature());
        DefaultReactorQLMetadata.addGlobal(new SelectFeature());
        DefaultReactorQLMetadata.addGlobal(new IfValueMapFeature());
        EqualsFilter eq = new EqualsFilter("=", false);
        DefaultReactorQLMetadata.addGlobal(eq);
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("eq", eq::test));
        EqualsFilter neq = new EqualsFilter("!=", true);
        DefaultReactorQLMetadata.addGlobal(neq);
        DefaultReactorQLMetadata.addGlobal(new EqualsFilter("<>", true));
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("neq", neq::test));
        DefaultReactorQLMetadata.addGlobal(new LikeFilter());
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("str_like", (left, right) -> LikeFilter.doTest(false, left, right)));
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("str_nlike", (left, right) -> LikeFilter.doTest(true, left, right)));
        GreaterTanFilter gt = new GreaterTanFilter(">");
        DefaultReactorQLMetadata.addGlobal(gt);
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("gt", gt::test));
        GreaterEqualsTanFilter gte = new GreaterEqualsTanFilter(">=");
        DefaultReactorQLMetadata.addGlobal(gte);
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("gte", gte::test));
        LessTanFilter lt = new LessTanFilter("<");
        DefaultReactorQLMetadata.addGlobal(lt);
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("lt", lt::test));
        LessEqualsTanFilter lte = new LessEqualsTanFilter("<=");
        DefaultReactorQLMetadata.addGlobal(lte);
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("lte", lte::test));
        DefaultReactorQLMetadata.addGlobal(new AndFilter());
        DefaultReactorQLMetadata.addGlobal(new OrFilter());
        DefaultReactorQLMetadata.addGlobal(new BetweenFilter());
        DefaultReactorQLMetadata.addGlobal(new InFilter());
        DefaultReactorQLMetadata.addGlobal(new NowFeature());
        DefaultReactorQLMetadata.addGlobal(new CastFeature());
        DefaultReactorQLMetadata.addGlobal(new DateFormatFeature());
        DefaultReactorQLMetadata.addGlobal(new GroupByIntervalFeature());
        DefaultReactorQLMetadata.addGlobal(new GroupByTakeFeature());
        Arrays.asList("property", "concat", "||", "ceil", "round", "floor", "date_format", "cast").forEach(type -> DefaultReactorQLMetadata.addGlobal(new GroupByValueFeature((String)type)));
        DefaultReactorQLMetadata.addGlobal(new GroupByWindowFeature());
        DefaultReactorQLMetadata.createCalculator(GroupByCalculateBinaryFeature::new, DefaultReactorQLMetadata::addGlobal);
        DefaultReactorQLMetadata.createCalculator(BinaryCalculateMapFeature::new, DefaultReactorQLMetadata::addGlobal);
        DefaultReactorQLMetadata.addGlobal(new CoalesceMapFeature());
        BiFunction<Object, Object, Object> concat = (left, right) -> {
            if (left == null) {
                left = "";
            }
            if (right == null) {
                right = "";
            }
            return String.valueOf(left).concat(String.valueOf(right));
        };
        DefaultReactorQLMetadata.addGlobal(new BinaryMapFeature("||", concat));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("concat", 9999, 1, stream -> ((Flux)stream.as(CastUtils::flatStream)).map(String::valueOf).collect(Collectors.joining())));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("substr", 3, 2, stream -> stream.collectList().filter(l -> l.size() >= 2).map(list -> {
            int length;
            String str = String.valueOf(list.get(0));
            int start = CastUtils.castNumber(list.get(1)).intValue();
            int n = length = list.size() == 2 ? str.length() : CastUtils.castNumber(list.get(2)).intValue();
            if (start < 0) {
                start = str.length() + start;
            }
            if (start < 0 || str.length() < start) {
                return "";
            }
            int endIndex = start + length;
            if (str.length() < endIndex) {
                return str.substring(start);
            }
            return str.substring(start, start + length);
        })));
        BiFunction<Flux, BiFunction, Flux> containsHandler = (stream, handler) -> CastUtils.handleFirst(stream, (first, flux) -> {
            Set<Object> arr = CastUtils.castSet(first);
            return (Publisher)handler.apply(arr, flux.skip(1L).as(CastUtils::flatStream));
        });
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("contains_all", 999, 2, stream -> (Flux)containsHandler.apply((Flux)stream, (left, data) -> data.all(left::contains))));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("not_contains", 999, 2, stream -> (Flux)containsHandler.apply((Flux)stream, (left, data) -> (Mono)data.any(left::contains).as(BooleanUtils::not))));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("contains_any", 999, 2, stream -> (Flux)containsHandler.apply((Flux)stream, (left, data) -> data.any(left::contains))));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("in", 9999, 2, stream -> CastUtils.handleFirst(stream, (first, flux) -> ((Flux)flux.skip(1L).as(CastUtils::flatStream)).any(v -> CompareUtils.equals(v, first)))));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("nin", 9999, 2, stream -> CastUtils.handleFirst(stream, (first, flux) -> ((Flux)flux.skip(1L).as(CastUtils::flatStream)).all(v -> !CompareUtils.equals(v, first)))));
        Function<Flux<Object>, Publisher<?>> btw = stream -> CastUtils.handleFirst(stream, (first, flux) -> ((Flux)flux.skip(1L).as(CastUtils::flatStream)).collectList().map(list -> {
            Object left = list.size() > 0 ? list.get(0) : null;
            Object right = list.size() > 1 ? list.get(list.size() - 1) : null;
            return BetweenFilter.predicate(first, left, right);
        }));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("btw", 3, 2, btw));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("range", 3, 2, btw));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("nbtw", 3, 2, stream -> BooleanUtils.not((Mono)Mono.from((Publisher)((Publisher)btw.apply((Flux<Object>)stream))).cast(Boolean.class))));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("row_to_array", 9999, 1, stream -> stream.flatMap(v -> Mono.justOrEmpty(CastUtils.tryGetFirstValueOptional(v))).collect(Collectors.toList())));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("array_to_row", 3, 3, stream -> stream.collectList().map(arr -> {
            List<Object> values = CastUtils.castArray(arr.get(0));
            Object key = arr.get(1);
            Object valueKey = arr.get(2);
            return CastUtils.listToMap(values, key, valueKey);
        })));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("rows_to_array", 9999, 1, stream -> ((Flux)stream.as(CastUtils::flatStream)).flatMap(v -> Mono.justOrEmpty(CastUtils.tryGetFirstValueOptional(v))).collect(Collectors.toList())));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("new_array", 9999, 1, stream -> stream.collect(Collectors.toList())));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("new_map", 9999, 1, stream -> stream.collectList().map(CastUtils::castMap)));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("bit_not", v -> CalculateUtils.bitNot(CastUtils.castNumber(v))));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("bit_count", v -> CalculateUtils.bitCount(CastUtils.castNumber(v))));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.log", v -> Math.log(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.log1p", v -> Math.log1p(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.log10", v -> Math.log10(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.exp", v -> Math.exp(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.expm1", v -> Math.expm1(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.rint", v -> Math.rint(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.sin", v -> Math.sin(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.asin", v -> Math.asin(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.sinh", v -> Math.sinh(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.cos", v -> Math.cos(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.cosh", v -> Math.cosh(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.acos", v -> Math.acos(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.tan", v -> Math.tan(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.tanh", v -> Math.tanh(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.atan", v -> Math.atan(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.ceil", v -> Math.ceil(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.round", v -> Math.round(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.floor", v -> Math.floor(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.abs", v -> Math.abs(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.degrees", v -> Math.toDegrees(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new SingleParameterFunctionMapFeature("math.radians", v -> Math.toRadians(CastUtils.castNumber(v).doubleValue())));
        DefaultReactorQLMetadata.addGlobal(new MapAggFeature("take", (arg, flux) -> {
            Flux stream = flux;
            int n = arg.size() > 0 ? ((Number)arg.get(0)).intValue() : 1;
            stream = n >= 0 ? stream.take((long)n) : stream.takeLast(-n);
            if (arg.size() > 1) {
                int take = ((Number)arg.get(1)).intValue();
                stream = take >= 0 ? stream.take((long)take) : stream.takeLast(-take);
            }
            return stream;
        }));
        DefaultReactorQLMetadata.addGlobal(new MapAggFeature("sum", flux -> MathFlux.sumDouble((Publisher)flux.map(CastUtils::castNumber).defaultIfEmpty((Object)0.0))));
        DefaultReactorQLMetadata.addGlobal(new MapAggFeature("avg", flux -> MathFlux.averageDouble((Publisher)flux.map(CastUtils::castNumber).defaultIfEmpty((Object)0.0))));
        DefaultReactorQLMetadata.addGlobal(new MapAggFeature("max", flux -> MathFlux.max((Publisher)flux, CompareUtils::compare).defaultIfEmpty((Object)0.0)));
        DefaultReactorQLMetadata.addGlobal(new MapAggFeature("min", flux -> MathFlux.min((Publisher)flux, CompareUtils::compare).defaultIfEmpty((Object)0.0)));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("math.max", 9999, 1, flux -> MathFlux.max((Publisher)((Publisher)flux.as(CastUtils::flatStream)), CompareUtils::compare).defaultIfEmpty((Object)0.0)));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("math.min", 9999, 1, flux -> MathFlux.min((Publisher)((Publisher)flux.as(CastUtils::flatStream)), CompareUtils::compare).defaultIfEmpty((Object)0.0)));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("math.avg", 9999, 1, flux -> MathFlux.averageDouble((Publisher)((Flux)flux.as(CastUtils::flatStream)).map(CastUtils::castNumber)).defaultIfEmpty((Object)0.0)));
        DefaultReactorQLMetadata.addGlobal(new FunctionMapFeature("math.count", 9999, 1, Flux::count));
        DefaultReactorQLMetadata.addGlobal(new TraceGroupRowFeature());
        DefaultReactorQLMetadata.addGlobal(new CollectRowAggMapFeature());
        DefaultReactorQLMetadata.addGlobal(new ArrayValueFlatMapFeature());
    }
}

