/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Scalar;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.ScalarKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\t2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J.\u0010\u0010\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u00112\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/Geodesic;", "", "()V", "FULL_ANGLE", "", "LONGITUDE_EPS", "addArcPointsToPath", "", "path", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLatPoint;", "start", "finish", "calculateIncreasingDistance", "createArcPath", "", "commons"})
public final class Geodesic {
    @NotNull
    public static final Geodesic INSTANCE = new Geodesic();
    private static final double LONGITUDE_EPS = 1.0;
    private static final double FULL_ANGLE = 360.0;

    private Geodesic() {
    }

    @NotNull
    public final List<Vec<LonLat>> createArcPath(@NotNull List<Vec<LonLat>> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        ArrayList<Vec<LonLat>> arcPath = new ArrayList<Vec<LonLat>>();
        if (path.isEmpty()) {
            return arcPath;
        }
        arcPath.add(path.get(0));
        int n = path.size();
        for (int i = 1; i < n; ++i) {
            this.addArcPointsToPath((List<Vec<LonLat>>)arcPath, path.get(i - 1), path.get(i));
            arcPath.add(path.get(i));
        }
        return arcPath;
    }

    private final void addArcPointsToPath(List<Vec<LonLat>> path, Vec<LonLat> start, Vec<LonLat> finish) {
        double lonDelta = Math.abs(start.getX() - finish.getX());
        if (lonDelta <= 1.0) {
            return;
        }
        if (Math.abs(180.0 - lonDelta) < 1.0) {
            double sign = ScalarKt.compareTo-ZDqpIUE(ScalarKt.plus-plX9Htw(VecKt.getScalarY(start), VecKt.getScalarY(finish)), 0) >= 0 ? 1.0 : -1.0;
            double latitude = sign * 180.0 / 2.0;
            path.add(VecKt.transform$default(start, null, (Function1)new Function1<Scalar<LonLat>, Scalar<LonLat>>(latitude){
                final /* synthetic */ double $latitude;
                {
                    this.$latitude = $latitude;
                    super(1);
                }

                public final double invoke-nwvo2uo(double it) {
                    return Scalar.constructor-impl(this.$latitude);
                }
            }, 1, null));
            path.add(VecKt.transform$default(finish, null, (Function1)new Function1<Scalar<LonLat>, Scalar<LonLat>>(latitude){
                final /* synthetic */ double $latitude;
                {
                    this.$latitude = $latitude;
                    super(1);
                }

                public final double invoke-nwvo2uo(double it) {
                    return Scalar.constructor-impl(this.$latitude);
                }
            }, 1, null));
            return;
        }
        double directionSign = this.calculateIncreasingDistance(start.getX(), finish.getX()) <= this.calculateIncreasingDistance(finish.getX(), start.getX()) ? 1.0 : -1.0;
        double startLatTan = Math.tan(MathKt.toRadians(start.getY()));
        double finishLatTan = Math.tan(MathKt.toRadians(finish.getY()));
        double deltaLonSin = Math.sin(MathKt.toRadians(finish.getX() - start.getX()));
        double longitude = start.getX();
        while (Math.abs(longitude - finish.getX()) > 1.0) {
            longitude += directionSign * 1.0;
            longitude = GeographicKt.normalizeLon(longitude);
            double latitude = MathKt.toDegrees(Math.atan((finishLatTan * Math.sin(MathKt.toRadians(longitude - start.getX())) + startLatTan * Math.sin(MathKt.toRadians(finish.getX() - longitude))) / deltaLonSin));
            path.add(VecKt.explicitVec(longitude, latitude));
        }
    }

    private final double calculateIncreasingDistance(double start, double finish) {
        double dist;
        return dist + ((dist = finish - start) < 0.0 ? 360.0 : 0.0);
    }
}

