/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u0010\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\fH\u0016J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "", "duration", "", "(J)V", "getDuration", "()J", "isPositive", "", "()Z", "add", "compareTo", "", "other", "div", "", "equals", "", "hashCode", "mul", "times", "sub", "toString", "", "Companion", "commons"})
public final class Duration
implements Comparable<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long duration;
    @NotNull
    private static final Duration MS = new Duration(1L);
    @NotNull
    private static final Duration SECOND = MS.mul(1000L);
    @NotNull
    private static final Duration MINUTE = SECOND.mul(60L);
    @NotNull
    private static final Duration HOUR = MINUTE.mul(60L);
    @NotNull
    private static final Duration DAY = HOUR.mul(24L);
    @NotNull
    private static final Duration WEEK = DAY.mul(7L);

    public Duration(long duration) {
        this.duration = duration;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final boolean isPositive() {
        return this.duration > 0L;
    }

    @NotNull
    public final Duration mul(long times) {
        return new Duration(this.duration * times);
    }

    @NotNull
    public final Duration add(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Duration(this.duration + duration.duration);
    }

    @NotNull
    public final Duration sub(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Duration(this.duration - duration.duration);
    }

    public final double div(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return (double)this.duration / (double)duration.duration;
    }

    @Override
    public int compareTo(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long delta = this.duration - other.duration;
        return delta > 0L ? 1 : (delta == 0L ? 0 : -1);
    }

    public int hashCode() {
        return (int)this.duration;
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof Duration) ? false : this.duration == ((Duration)other).duration;
    }

    @NotNull
    public String toString() {
        return "Duration : " + this.duration + "ms";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0015\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0015\u0010\u0017\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0015\u0010\u0019\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0015\u0010\u001b\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0015\u0010\u001d\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u0015\u0010\u001f\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0015\u0010!\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0015\u0010#\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0014R\u0015\u0010%\u001a\u00020\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration$Companion;", "", "()V", "DAY", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "getDAY", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "HOUR", "getHOUR", "MINUTE", "getMINUTE", "MS", "getMS", "SECOND", "getSECOND", "WEEK", "getWEEK", "day", "", "getDay", "(Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;)J", "hour", "getHour", "millis", "getMillis", "minute", "getMinute", "second", "getSecond", "totalDays", "getTotalDays", "totalHours", "getTotalHours", "totalMinutes", "getTotalMinutes", "totalWeeks", "getTotalWeeks", "week", "getWeek", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getMS() {
            return MS;
        }

        @NotNull
        public final Duration getSECOND() {
            return SECOND;
        }

        @NotNull
        public final Duration getMINUTE() {
            return MINUTE;
        }

        @NotNull
        public final Duration getHOUR() {
            return HOUR;
        }

        @NotNull
        public final Duration getDAY() {
            return DAY;
        }

        @NotNull
        public final Duration getWEEK() {
            return WEEK;
        }

        public final long getWeek(@NotNull Duration $this$week) {
            Intrinsics.checkNotNullParameter((Object)$this$week, (String)"<this>");
            return $this$week.getDuration() / this.getWEEK().getDuration();
        }

        public final long getDay(@NotNull Duration $this$day) {
            Intrinsics.checkNotNullParameter((Object)$this$day, (String)"<this>");
            return $this$day.getDuration() % this.getWEEK().getDuration() / this.getDAY().getDuration();
        }

        public final long getHour(@NotNull Duration $this$hour) {
            Intrinsics.checkNotNullParameter((Object)$this$hour, (String)"<this>");
            return $this$hour.getDuration() % this.getDAY().getDuration() / this.getHOUR().getDuration();
        }

        public final long getMinute(@NotNull Duration $this$minute) {
            Intrinsics.checkNotNullParameter((Object)$this$minute, (String)"<this>");
            return $this$minute.getDuration() % this.getHOUR().getDuration() / this.getMINUTE().getDuration();
        }

        public final long getSecond(@NotNull Duration $this$second) {
            Intrinsics.checkNotNullParameter((Object)$this$second, (String)"<this>");
            return $this$second.getDuration() % this.getMINUTE().getDuration() / this.getSECOND().getDuration();
        }

        public final long getMillis(@NotNull Duration $this$millis) {
            Intrinsics.checkNotNullParameter((Object)$this$millis, (String)"<this>");
            return $this$millis.getDuration() % this.getSECOND().getDuration() / this.getMS().getDuration();
        }

        public final long getTotalWeeks(@NotNull Duration $this$totalWeeks) {
            Intrinsics.checkNotNullParameter((Object)$this$totalWeeks, (String)"<this>");
            return $this$totalWeeks.getDuration() / this.getWEEK().getDuration();
        }

        public final long getTotalDays(@NotNull Duration $this$totalDays) {
            Intrinsics.checkNotNullParameter((Object)$this$totalDays, (String)"<this>");
            return $this$totalDays.getDuration() / this.getDAY().getDuration();
        }

        public final long getTotalHours(@NotNull Duration $this$totalHours) {
            Intrinsics.checkNotNullParameter((Object)$this$totalHours, (String)"<this>");
            return $this$totalHours.getDuration() / this.getDAY().getDuration();
        }

        public final long getTotalMinutes(@NotNull Duration $this$totalMinutes) {
            Intrinsics.checkNotNullParameter((Object)$this$totalMinutes, (String)"<this>");
            return $this$totalMinutes.getDuration() / this.getMINUTE().getDuration();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

