/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelToTsDeclarations;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelToTsDeclarations$toReadonlyProperty$;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructSignature;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u001aH\u0002J\u0014\u0010\u0019\u001a\u00020\u0007*\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u0019\u001a\u00020\u0007*\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u0007*\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u0007*\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u0007*\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u0007*\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\f\u0010\"\u001a\u00020\u0017*\u00020!H\u0002J\u0014\u0010#\u001a\u00020\u0007*\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010%\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020$0\u00122\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010'\u001a\u00020\u0005*\u00020\u0018H\u0002J\u001a\u0010(\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010(\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001e\u0010(\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u001e\u001a\u00020\u0007H\u0002J\u0014\u0010(\u001a\u00020\u0007*\u00020)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010(\u001a\u00020\u0007*\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010*\u001a\u00020\u0017H\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\f\u0010,\u001a\u00020!*\u00020\u0018H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelToTsDeclarations;", "", "()V", "objectsSyntheticProperties", "", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedProperty;", "indent", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "getIndent", "(Lorg/jetbrains/kotlin/serialization/js/ModuleKind;)Ljava/lang/String;", "generateObjectsNamespaceIfNeeded", "generateTypeScript", "name", "module", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "moduleKind", "declarations", "", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "asNestedClassAccess", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "couldBeProperty", "", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClass;", "generateTypeScriptString", "Lorg/jetbrains/kotlin/ir/backend/js/export/ErrorDeclaration;", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedConstructSignature;", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedConstructor;", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedFunction;", "prefix", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedNamespace;", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedObject;", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedRegularClass;", "shouldNotBeImplemented", "toExtendsClause", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "toImplementsClause", "superInterfacesKeyword", "toReadonlyProperty", "toTypeScript", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "isInCommentContext", "withMagicProperty", "withProtectedConstructors", "backend.js"})
public final class ExportModelToTsDeclarations {
    @NotNull
    private final List<ExportedProperty> objectsSyntheticProperties = new ArrayList();

    private final String getIndent(ModuleKind $this$indent) {
        return $this$indent == ModuleKind.PLAIN ? "    " : "";
    }

    @NotNull
    public final String generateTypeScript(@NotNull String name, @NotNull ExportedModule module2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        String declareKeyword = WhenMappings.$EnumSwitchMapping$0[module2.getModuleKind().ordinal()] == 1 ? "" : "declare ";
        String types2 = StringsKt.prependIndent((String)StringsKt.trimIndent((String)("\n       type Nullable<T> = T | null | undefined\n       " + declareKeyword + "const __doNotImplementIt: unique symbol\n       type __doNotImplementIt = typeof __doNotImplementIt\n    ")), (String)this.getIndent(module2.getModuleKind())) + '\n';
        String declarationsDts = types2 + this.toTypeScript(module2.getDeclarations(), module2.getModuleKind());
        String namespaceName = NameTablesKt.sanitizeName(name, false);
        switch (WhenMappings.$EnumSwitchMapping$0[module2.getModuleKind().ordinal()]) {
            case 1: {
                string2 = "declare namespace " + namespaceName + " {\n" + declarationsDts + "\n}\n";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = declarationsDts;
                break;
            }
            case 5: {
                string2 = declarationsDts + "\nexport as namespace " + namespaceName + ';';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public final String generateTypeScript(@NotNull ModuleKind moduleKind, @NotNull List<? extends ExportedDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        return this.toTypeScript(declarations2, moduleKind);
    }

    private final String toTypeScript(List<? extends ExportedDeclaration> $this$toTypeScript, ModuleKind moduleKind) {
        return CollectionsKt.joinToString$default((Iterable)$this$toTypeScript, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedDeclaration, CharSequence>(this, moduleKind){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ ModuleKind $moduleKind;
            {
                this.this$0 = $receiver;
                this.$moduleKind = $moduleKind;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.access$toTypeScript(this.this$0, it, ExportModelToTsDeclarations.access$getIndent(this.this$0, this.$moduleKind), this.$moduleKind == ModuleKind.PLAIN ? "" : "export ");
            }
        }), (int)30, null) + this.generateObjectsNamespaceIfNeeded(this.getIndent(moduleKind));
    }

    private final String generateObjectsNamespaceIfNeeded(String indent) {
        return this.objectsSyntheticProperties.isEmpty() ? "" : '\n' + this.toTypeScript(new ExportedNamespace("_objects_", this.objectsSyntheticProperties), indent, "");
    }

    private final String toTypeScript(List<? extends ExportedDeclaration> $this$toTypeScript, String indent) {
        return CollectionsKt.joinToString$default((Iterable)$this$toTypeScript, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedDeclaration, CharSequence>(this, indent){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ String $indent;
            {
                this.this$0 = $receiver;
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.toTypeScript$default(this.this$0, it, this.$indent, null, 2, null) + '\n';
            }
        }), (int)30, null);
    }

    private final String toTypeScript(ExportedDeclaration $this$toTypeScript, String indent, String prefix) {
        String string2;
        StringBuilder stringBuilder2 = new StringBuilder().append(indent);
        ExportedDeclaration exportedDeclaration = $this$toTypeScript;
        if (exportedDeclaration instanceof ErrorDeclaration) {
            string2 = this.generateTypeScriptString((ErrorDeclaration)$this$toTypeScript);
        } else if (exportedDeclaration instanceof ExportedNamespace) {
            string2 = this.generateTypeScriptString((ExportedNamespace)$this$toTypeScript, indent, prefix);
        } else if (exportedDeclaration instanceof ExportedFunction) {
            string2 = this.generateTypeScriptString((ExportedFunction)$this$toTypeScript, indent, prefix);
        } else if (exportedDeclaration instanceof ExportedConstructor) {
            string2 = this.generateTypeScriptString((ExportedConstructor)$this$toTypeScript, indent);
        } else if (exportedDeclaration instanceof ExportedConstructSignature) {
            string2 = this.generateTypeScriptString((ExportedConstructSignature)$this$toTypeScript, indent);
        } else if (exportedDeclaration instanceof ExportedProperty) {
            string2 = this.generateTypeScriptString((ExportedProperty)$this$toTypeScript, indent, prefix);
        } else if (exportedDeclaration instanceof ExportedObject) {
            string2 = this.generateTypeScriptString((ExportedObject)$this$toTypeScript, indent, prefix);
        } else if (exportedDeclaration instanceof ExportedRegularClass) {
            string2 = this.generateTypeScriptString((ExportedRegularClass)$this$toTypeScript, indent, prefix);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stringBuilder2.append(string2).toString();
    }

    static /* synthetic */ String toTypeScript$default(ExportModelToTsDeclarations exportModelToTsDeclarations, ExportedDeclaration exportedDeclaration, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        return exportModelToTsDeclarations.toTypeScript(exportedDeclaration, string2, string3);
    }

    private final String generateTypeScriptString(ErrorDeclaration $this$generateTypeScriptString) {
        return "/* ErrorDeclaration: " + $this$generateTypeScriptString.getMessage() + " */";
    }

    private final String generateTypeScriptString(ExportedNamespace $this$generateTypeScriptString, String indent, String prefix) {
        return prefix + "namespace " + $this$generateTypeScriptString.getName() + " {\n" + this.toTypeScript($this$generateTypeScriptString.getDeclarations(), indent + "    ") + indent + '}';
    }

    private final String generateTypeScriptString(ExportedConstructor $this$generateTypeScriptString, String indent) {
        String renderedParameters2 = CollectionsKt.joinToString$default((Iterable)$this$generateTypeScriptString.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedParameter, CharSequence>(this, indent){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ String $indent;
            {
                this.this$0 = $receiver;
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.access$toTypeScript(this.this$0, it, this.$indent);
            }
        }), (int)30, null);
        return $this$generateTypeScriptString.getVisibility().getKeyword() + "constructor(" + renderedParameters2 + ");";
    }

    private final String generateTypeScriptString(ExportedConstructSignature $this$generateTypeScriptString, String indent) {
        String renderedParameters2 = CollectionsKt.joinToString$default((Iterable)$this$generateTypeScriptString.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedParameter, CharSequence>(this, indent){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ String $indent;
            {
                this.this$0 = $receiver;
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.access$toTypeScript(this.this$0, it, this.$indent);
            }
        }), (int)30, null);
        return "new(" + renderedParameters2 + "): " + ExportModelToTsDeclarations.toTypeScript$default(this, $this$generateTypeScriptString.getReturnType(), indent, false, 2, null) + ';';
    }

    private final String generateTypeScriptString(ExportedProperty $this$generateTypeScriptString, String indent, String prefix) {
        String string2;
        String visibility2 = $this$generateTypeScriptString.isProtected() ? "protected " : "";
        String keyword = $this$generateTypeScriptString.isMember() ? ($this$generateTypeScriptString.isAbstract() ? "abstract " : "") : ($this$generateTypeScriptString.getMutable() ? "let " : "const ");
        String possibleStatic = $this$generateTypeScriptString.isMember() && $this$generateTypeScriptString.isStatic() ? "static " : "";
        boolean containsUnresolvedChar = !IdentifierPolicyKt.isValidES5Identifier($this$generateTypeScriptString.getName());
        String memberName = $this$generateTypeScriptString.isMember() && containsUnresolvedChar ? '\"' + $this$generateTypeScriptString.getName() + '\"' : $this$generateTypeScriptString.getName();
        String typeToTypeScript = ExportModelToTsDeclarations.toTypeScript$default(this, $this$generateTypeScriptString.getType(), indent, false, 2, null);
        if ($this$generateTypeScriptString.isMember() && !$this$generateTypeScriptString.isField()) {
            String getter2 = prefix + visibility2 + possibleStatic + keyword + "get " + memberName + "(): " + typeToTypeScript + ';';
            string2 = !$this$generateTypeScriptString.getMutable() ? getter2 : getter2 + '\n' + indent + prefix + visibility2 + possibleStatic + keyword + "set " + memberName + "(value: " + typeToTypeScript + ");";
        } else if (!$this$generateTypeScriptString.isMember() && containsUnresolvedChar) {
            string2 = "";
        } else {
            String readonly = $this$generateTypeScriptString.isMember() && !$this$generateTypeScriptString.getMutable() ? "readonly " : "";
            string2 = prefix + visibility2 + possibleStatic + keyword + readonly + memberName + ": " + typeToTypeScript + ';';
        }
        return string2;
    }

    private final String generateTypeScriptString(ExportedFunction $this$generateTypeScriptString, String indent, String prefix) {
        String visibility2 = $this$generateTypeScriptString.isProtected() ? "protected " : "";
        String keyword = $this$generateTypeScriptString.isMember() ? ($this$generateTypeScriptString.isStatic() ? "static " : ($this$generateTypeScriptString.isAbstract() ? "abstract " : "")) : "function ";
        String renderedParameters2 = CollectionsKt.joinToString$default((Iterable)$this$generateTypeScriptString.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedParameter, CharSequence>(this, indent){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ String $indent;
            {
                this.this$0 = $receiver;
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.access$toTypeScript(this.this$0, it, this.$indent);
            }
        }), (int)30, null);
        String renderedTypeParameters2 = !((Collection)$this$generateTypeScriptString.getTypeParameters()).isEmpty() ? '<' + CollectionsKt.joinToString$default((Iterable)$this$generateTypeScriptString.getTypeParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedType.TypeParameter, CharSequence>(this, indent){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ String $indent;
            {
                this.this$0 = $receiver;
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedType.TypeParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.toTypeScript$default(this.this$0, it, this.$indent, false, 2, null);
            }
        }), (int)30, null) + '>' : "";
        String renderedReturnType = ExportModelToTsDeclarations.toTypeScript$default(this, $this$generateTypeScriptString.getReturnType(), indent, false, 2, null);
        boolean containsUnresolvedChar = !IdentifierPolicyKt.isValidES5Identifier($this$generateTypeScriptString.getName());
        String escapedName = $this$generateTypeScriptString.isMember() && containsUnresolvedChar ? '\"' + $this$generateTypeScriptString.getName() + '\"' : $this$generateTypeScriptString.getName();
        return !$this$generateTypeScriptString.isMember() && containsUnresolvedChar ? "" : prefix + visibility2 + keyword + escapedName + renderedTypeParameters2 + '(' + renderedParameters2 + "): " + renderedReturnType + ';';
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final String generateTypeScriptString(ExportedObject $this$generateTypeScriptString, String indent, String prefix) {
        shouldRenderSeparatedAbstractClass = this.couldBeProperty($this$generateTypeScriptString) == false;
        t = new ExportedType.InlineInterfaceType($this$generateTypeScriptString.getMembers());
        if ($this$generateTypeScriptString.getSuperClass() != null) {
            t = new ExportedType.IntersectionType(t, $this$generateTypeScriptString.getSuperClass());
        }
        for (Object superInterface : $this$generateTypeScriptString.getSuperInterfaces()) {
            t = new ExportedType.IntersectionType(t, (ExportedType)superInterface);
        }
        if (shouldRenderSeparatedAbstractClass) {
            constructor = new ExportedConstructSignature(CollectionsKt.emptyList(), ExportedType.Primitive.Any.INSTANCE);
            t = new ExportedType.IntersectionType(t, new ExportedType.InlineInterfaceType(CollectionsKt.listOf((Object)constructor)));
        }
        maybeParentClass = (superInterface = $this$generateTypeScriptString.getIr().getParent()) instanceof IrClass != false ? (IrClass)superInterface : null;
        it = var9_8 = $this$generateTypeScriptString.getIr();
        $i$a$-takeIf-ExportModelToTsDeclarations$generateTypeScriptString$propertyName$1 = false;
        var8_15 = shouldRenderSeparatedAbstractClass != false ? var9_8 : null;
        propertyName = var8_15 != null && (var9_8 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable(var8_15, true)) != null && (it = var9_8.asString()) != null && ($i$a$-takeIf-ExportModelToTsDeclarations$generateTypeScriptString$propertyName$1 = StringsKt.replace$default((String)it, (char)'.', (char)'$', (boolean)false, (int)4, null)) != null ? $i$a$-takeIf-ExportModelToTsDeclarations$generateTypeScriptString$propertyName$1 : $this$generateTypeScriptString.getName();
        var9_8 = t;
        v0 = it = maybeParentClass != null && shouldRenderSeparatedAbstractClass == false;
        if ($this$generateTypeScriptString.getIr().isInner()) ** GOTO lbl-1000
        v1 = maybeParentClass;
        v2 = v1 != null ? !IrUtilsKt.isObject(v1) : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        $i$a$-takeIf-ExportModelToTsDeclarations$generateTypeScriptString$propertyName$1 = v3;
        var12_16 = Intrinsics.areEqual((Object)$this$generateTypeScriptString.getIr().getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        var13_18 = $this$generateTypeScriptString.getIrGetter();
        property = new ExportedProperty(propertyName, (ExportedType)var9_8, false, it, $i$a$-takeIf-ExportModelToTsDeclarations$generateTypeScriptString$propertyName$1, false, var12_16, false, var13_18, null);
        if (!shouldRenderSeparatedAbstractClass) {
            v4 = this.generateTypeScriptString(property, indent, prefix);
        } else {
            propertyRef = "_objects_." + propertyName;
            shouldCreateExtraProperty = ((Collection)$this$generateTypeScriptString.getMembers()).isEmpty() == false != false || ((Collection)$this$generateTypeScriptString.getSuperInterfaces()).isEmpty() == false != false || $this$generateTypeScriptString.getSuperClass() != null;
            it = var12_17 = new ExportedType.ClassType(propertyRef, CollectionsKt.emptyList(), $this$generateTypeScriptString.getIr());
            $i$a$-takeIf-ExportModelToTsDeclarations$generateTypeScriptString$newSuperClass$1 = false;
            newSuperClass = shouldCreateExtraProperty != false ? var12_17 : null;
            it = var12_17 = this.generateTypeScriptString(new ExportedRegularClass($this$generateTypeScriptString.getName(), false, true, newSuperClass, $this$generateTypeScriptString.getSuperInterfaces(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new ExportedConstructor(CollectionsKt.emptyList(), ExportedVisibility.PRIVATE)), $this$generateTypeScriptString.getNestedClasses(), $this$generateTypeScriptString.getIr()), indent, prefix);
            $i$a$-also-ExportModelToTsDeclarations$generateTypeScriptString$1 = false;
            if (shouldCreateExtraProperty) {
                this.objectsSyntheticProperties.add(property);
            }
            v4 = var12_17;
        }
        return v4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String generateTypeScriptString(ExportedRegularClass $this$generateTypeScriptString, String indent, String prefix) {
        block16: {
            block18: {
                block17: {
                    keyword = $this$generateTypeScriptString.isInterface() != false ? "interface" : "class";
                    superInterfacesKeyword = $this$generateTypeScriptString.isInterface() != false ? "extends" : "implements";
                    v0 = $this$generateTypeScriptString.getSuperClass();
                    if (v0 == null) break block17;
                    it = v0;
                    $i$a$-let-ExportModelToTsDeclarations$generateTypeScriptString$superClassClause$1 = false;
                    v1 = this.toExtendsClause(it, indent);
                    v0 = v1;
                    if (v1 != null) break block18;
                }
                v0 = "";
            }
            superClassClause = v0;
            superInterfacesClause = this.toImplementsClause($this$generateTypeScriptString.getSuperInterfaces(), superInterfacesKeyword, indent);
            $this$partition$iv = $this$generateTypeScriptString.getNestedClasses();
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv /* !! */  = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (ExportedClass)element$iv;
                $i$a$-partition-ExportModelToTsDeclarations$generateTypeScriptString$2 = false;
                if (this.couldBeProperty(it)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv /* !! */ .add(element$iv);
            }
            var8_26 = new Pair(first$iv, second$iv /* !! */ );
            memberObjects = (List)var8_26.component1();
            nestedDeclarations = (List)var8_26.component2();
            it = $this$generateTypeScriptString.getMembers();
            $i$a$-let-ExportModelToTsDeclarations$generateTypeScriptString$members$1 = false;
            second$iv /* !! */  = this.shouldNotBeImplemented($this$generateTypeScriptString) != false ? this.withMagicProperty(it) : it;
            $i$f$map = false;
            $i$a$-let-ExportModelToTsDeclarations$generateTypeScriptString$members$1 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var19_31 = (ExportedDeclaration)item$iv$iv;
                var31_37 = destination$iv$iv;
                $i$a$-map-ExportModelToTsDeclarations$generateTypeScriptString$members$2 = false;
                var31_37.add(!($this$generateTypeScriptString.getIr().isInner() && it instanceof ExportedFunction && ((ExportedFunction)it).isStatic()) ? it : (ExportedDeclaration)ExportedFunction.copy$default((ExportedFunction)it, null, null, CollectionsKt.drop((Iterable)((ExportedFunction)it).getParameters(), (int)1), null, false, false, false, false, null, 507, null));
            }
            members = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)memberObjects);
            $this$partition$iv = nestedDeclarations;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (ExportedClass)element$iv /* !! */ ;
                $i$a$-partition-ExportModelToTsDeclarations$generateTypeScriptString$3 = false;
                if (it.getIr().isInner()) {
                    first$iv.add(element$iv /* !! */ );
                    continue;
                }
                second$iv.add(element$iv /* !! */ );
            }
            var12_14 = new Pair(first$iv, second$iv);
            innerClasses = (List)var12_14.component1();
            nonInnerClasses = (List)var12_14.component2();
            $this$map$iv = innerClasses;
            $i$f$map = false;
            element$iv /* !! */  = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var23_40 = (ExportedClass)item$iv$iv;
                var31_37 = destination$iv$iv;
                $i$a$-map-ExportModelToTsDeclarations$generateTypeScriptString$innerClassesProperties$1 = false;
                var31_37.add(this.toReadonlyProperty((ExportedClass)it));
            }
            innerClassesProperties = (List)destination$iv$iv;
            membersString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)members, (Iterable)innerClassesProperties), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedDeclaration, CharSequence>(this, indent){
                final /* synthetic */ ExportModelToTsDeclarations this$0;
                final /* synthetic */ String $indent;
                {
                    this.this$0 = $receiver;
                    this.$indent = $indent;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ExportedDeclaration it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ExportModelToTsDeclarations.toTypeScript$default(this.this$0, it, this.$indent + "    ", null, 2, null) + '\n';
                }
            }), (int)30, null);
            if ($this$generateTypeScriptString.isInterface() || $this$generateTypeScriptString.isAbstract()) ** GOTO lbl-1000
            $this$none$iv = members;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ExportedDeclaration)element$iv;
                    $i$a$-none-ExportModelToTsDeclarations$generateTypeScriptString$privateCtorString$1 = false;
                    if (!(it instanceof ExportedConstructor)) continue;
                    v2 = false;
                    break block16;
                }
                v2 = true;
            }
        }
        if (v2) {
            v3 = indent + "    private constructor();\n";
        } else lbl-1000:
        // 2 sources

        {
            v3 = "";
        }
        privateCtorString = v3;
        renderedTypeParameters = ((Collection)$this$generateTypeScriptString.getTypeParameters()).isEmpty() == false != false ? '<' + CollectionsKt.joinToString$default((Iterable)$this$generateTypeScriptString.getTypeParameters(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + '>' : "";
        modifiers = $this$generateTypeScriptString.isAbstract() != false && $this$generateTypeScriptString.isInterface() == false ? "abstract " : "";
        bodyString = privateCtorString + membersString + indent;
        it = innerClasses;
        var31_37 = nonInnerClasses;
        $i$f$map = false;
        $i$a$-map-ExportModelToTsDeclarations$generateTypeScriptString$innerClassesProperties$1 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var29_50 = (ExportedClass)item$iv$iv;
            var32_52 = destination$iv$iv;
            $i$a$-map-ExportModelToTsDeclarations$generateTypeScriptString$nestedClasses$1 = false;
            var32_52.add(this.withProtectedConstructors((ExportedClass)it));
        }
        nestedClasses = CollectionsKt.plus((Collection)var31_37, (Iterable)((List)destination$iv$iv));
        klassExport = prefix + modifiers + keyword + ' ' + $this$generateTypeScriptString.getName() + renderedTypeParameters + (String)superClassClause + superInterfacesClause + " {\n" + bodyString + '}';
        staticsExport = ((Collection)nestedClasses).isEmpty() == false != false ? '\n' + this.toTypeScript(new ExportedNamespace($this$generateTypeScriptString.getName(), nestedClasses), indent, prefix) : "";
        return IdentifierPolicyKt.isValidES5Identifier($this$generateTypeScriptString.getName()) != false ? klassExport + staticsExport : "";
    }

    private final String toExtendsClause(ExportedType $this$toExtendsClause, String indent) {
        boolean isImplicitlyExportedType = $this$toExtendsClause instanceof ExportedType.ImplicitlyExportedType;
        String extendsClause = " extends " + this.toTypeScript($this$toExtendsClause, indent, isImplicitlyExportedType);
        return isImplicitlyExportedType ? " /*" + extendsClause + " */" : extendsClause;
    }

    private final String toImplementsClause(List<? extends ExportedType> $this$toImplementsClause, String superInterfacesKeyword, String indent) {
        String string2;
        Iterable $this$partition$iv = $this$toImplementsClause;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ExportedType it = (ExportedType)element$iv;
            boolean bl = false;
            if (!(it instanceof ExportedType.ImplicitlyExportedType)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List exportedInterfaces = (List)pair.component1();
        List nonExportedInterfaces = (List)pair.component2();
        String listOfNonExportedInterfaces2 = CollectionsKt.joinToString$default((Iterable)nonExportedInterfaces, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedType, CharSequence>(this, indent){
            final /* synthetic */ ExportModelToTsDeclarations this$0;
            final /* synthetic */ String $indent;
            {
                this.this$0 = $receiver;
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExportedType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportModelToTsDeclarations.access$toTypeScript(this.this$0, ((ExportedType.ImplicitlyExportedType)it).getType(), this.$indent, true);
            }
        }), (int)30, null);
        if (exportedInterfaces.isEmpty() && !((Collection)nonExportedInterfaces).isEmpty()) {
            string2 = " /* " + superInterfacesKeyword + ' ' + listOfNonExportedInterfaces2 + " */";
        } else if (!((Collection)exportedInterfaces).isEmpty()) {
            String nonExportedInterfacesTsString = !((Collection)nonExportedInterfaces).isEmpty() ? "/*, " + listOfNonExportedInterfaces2 + " */" : "";
            string2 = ' ' + superInterfacesKeyword + ' ' + CollectionsKt.joinToString$default((Iterable)exportedInterfaces, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedType, CharSequence>(this, indent){
                final /* synthetic */ ExportModelToTsDeclarations this$0;
                final /* synthetic */ String $indent;
                {
                    this.this$0 = $receiver;
                    this.$indent = $indent;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ExportedType it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ExportModelToTsDeclarations.toTypeScript$default(this.this$0, it, this.$indent, false, 2, null);
                }
            }), (int)30, null) + nonExportedInterfacesTsString;
        } else {
            string2 = "";
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldNotBeImplemented(ExportedRegularClass $this$shouldNotBeImplemented) {
        boolean bl;
        if ($this$shouldNotBeImplemented.isInterface()) {
            if (!$this$shouldNotBeImplemented.getIr().isExternal()) return true;
        }
        Iterable $this$any$iv = $this$shouldNotBeImplemented.getSuperInterfaces();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ExportedType it = (ExportedType)element$iv;
            boolean bl2 = false;
            if (it instanceof ExportedType.ClassType && !((ExportedType.ClassType)it).getIr().isExternal()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final List<ExportedDeclaration> withMagicProperty(List<? extends ExportedDeclaration> $this$withMagicProperty) {
        return CollectionsKt.plus((Collection)$this$withMagicProperty, (Object)new ExportedProperty("__doNotUseIt", new ExportedType.TypeParameter("__doNotImplementIt", null, 2, null), false, true, false, false, false, true, null, null));
    }

    private final String asNestedClassAccess(IrClass $this$asNestedClassAccess) {
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$asNestedClassAccess).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJsNameOrKotlinName().identifier");
        String name = string2;
        if (!($this$asNestedClassAccess.getParent() instanceof IrClass)) {
            return name;
        }
        return this.asNestedClassAccess(IrUtilsKt.getParentAsClass($this$asNestedClassAccess)) + '.' + name;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedRegularClass withProtectedConstructors(ExportedClass $this$withProtectedConstructors) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNull((Object)$this$withProtectedConstructors, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass");
        Iterable iterable = $this$withProtectedConstructors.getMembers();
        List list2 = null;
        List list3 = null;
        ExportedType exportedType = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        ExportedRegularClass exportedRegularClass = (ExportedRegularClass)$this$withProtectedConstructors;
        boolean $i$f$map = false;
        void var4_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExportedDeclaration exportedDeclaration = (ExportedDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add((void)(!(it instanceof ExportedConstructor) || ((ExportedConstructor)it).isProtected() ? it : (ExportedDeclaration)ExportedConstructor.copy$default((ExportedConstructor)it, null, ExportedVisibility.PROTECTED, 1, null)));
        }
        collection = (List)destination$iv$iv;
        return ExportedRegularClass.copy$default(exportedRegularClass, string2, bl2, bl, exportedType, list3, list2, (List)collection, null, null, 447, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedProperty toReadonlyProperty(ExportedClass $this$toReadonlyProperty) {
        void $this$filterIsInstance$iv;
        String innerClassReference = this.asNestedClassAccess($this$toReadonlyProperty.getIr());
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)$this$toReadonlyProperty.getMembers());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)toReadonlyProperty$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List allPublicConstructors2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)sequence3, (Function1)toReadonlyProperty.allPublicConstructors.1.INSTANCE), (Function1)((Function1)new Function1<ExportedConstructor, ExportedConstructSignature>(innerClassReference){
            final /* synthetic */ String $innerClassReference;
            {
                this.$innerClassReference = $innerClassReference;
                super(1);
            }

            @NotNull
            public final ExportedConstructSignature invoke(@NotNull ExportedConstructor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ExportedConstructSignature(CollectionsKt.drop((Iterable)it.getParameters(), (int)1), new ExportedType.TypeParameter(this.$innerClassReference, null, 2, null));
            }
        })));
        ExportedType.IntersectionType type2 = new ExportedType.IntersectionType(new ExportedType.InlineInterfaceType(allPublicConstructors2), new ExportedType.TypeOf(innerClassReference));
        return new ExportedProperty($this$toReadonlyProperty.getName(), type2, false, true, false, false, false, false, null, null);
    }

    private final String toTypeScript(ExportedParameter $this$toTypeScript, String indent) {
        String name = NameTablesKt.sanitizeName($this$toTypeScript.getName(), false);
        String type2 = ExportModelToTsDeclarations.toTypeScript$default(this, $this$toTypeScript.getType(), indent, false, 2, null);
        String questionMark = $this$toTypeScript.getHasDefaultValue() ? "?" : "";
        return name + questionMark + ": " + type2;
    }

    private final String toTypeScript(ExportedType $this$toTypeScript, String indent, boolean isInCommentContext) {
        String string2;
        ExportedType exportedType = $this$toTypeScript;
        if (exportedType instanceof ExportedType.Primitive) {
            string2 = ((ExportedType.Primitive)$this$toTypeScript).getTypescript();
        } else if (exportedType instanceof ExportedType.Array) {
            string2 = "Array<" + this.toTypeScript(((ExportedType.Array)$this$toTypeScript).getElementType(), indent, isInCommentContext) + '>';
        } else if (exportedType instanceof ExportedType.Function) {
            string2 = '(' + CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)((ExportedType.Function)$this$toTypeScript).getParameterTypes()), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IndexedValue<? extends ExportedType>, CharSequence>(this, indent, isInCommentContext){
                final /* synthetic */ ExportModelToTsDeclarations this$0;
                final /* synthetic */ String $indent;
                final /* synthetic */ boolean $isInCommentContext;
                {
                    this.this$0 = $receiver;
                    this.$indent = $indent;
                    this.$isInCommentContext = $isInCommentContext;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IndexedValue<? extends ExportedType> indexedValue) {
                    Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                    int index2 = indexedValue.component1();
                    ExportedType type2 = (ExportedType)indexedValue.component2();
                    return "" + 'p' + index2 + ": " + ExportModelToTsDeclarations.access$toTypeScript(this.this$0, type2, this.$indent, this.$isInCommentContext);
                }
            }), (int)30, null) + ") => " + this.toTypeScript(((ExportedType.Function)$this$toTypeScript).getReturnType(), indent, isInCommentContext);
        } else if (exportedType instanceof ExportedType.ClassType) {
            string2 = ((ExportedType.ClassType)$this$toTypeScript).getName() + (!((Collection)((ExportedType.ClassType)$this$toTypeScript).getArguments()).isEmpty() ? '<' + CollectionsKt.joinToString$default((Iterable)((ExportedType.ClassType)$this$toTypeScript).getArguments(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<ExportedType, CharSequence>(this, indent, isInCommentContext){
                final /* synthetic */ ExportModelToTsDeclarations this$0;
                final /* synthetic */ String $indent;
                final /* synthetic */ boolean $isInCommentContext;
                {
                    this.this$0 = $receiver;
                    this.$indent = $indent;
                    this.$isInCommentContext = $isInCommentContext;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ExportedType it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ExportModelToTsDeclarations.access$toTypeScript(this.this$0, it, this.$indent, this.$isInCommentContext);
                }
            }), (int)30, null) + '>' : "");
        } else if (exportedType instanceof ExportedType.TypeOf) {
            string2 = "typeof " + ((ExportedType.TypeOf)$this$toTypeScript).getName();
        } else if (exportedType instanceof ExportedType.ErrorType) {
            string2 = isInCommentContext ? ((ExportedType.ErrorType)$this$toTypeScript).getComment() : "any /*" + ((ExportedType.ErrorType)$this$toTypeScript).getComment() + "*/";
        } else if (exportedType instanceof ExportedType.Nullable) {
            string2 = "Nullable<" + this.toTypeScript(((ExportedType.Nullable)$this$toTypeScript).getBaseType(), indent, isInCommentContext) + '>';
        } else if (exportedType instanceof ExportedType.InlineInterfaceType) {
            List<ExportedDeclaration> list2 = ((ExportedType.InlineInterfaceType)$this$toTypeScript).getMembers();
            String string3 = indent + '}';
            string2 = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"", (CharSequence)"{\n", (CharSequence)string3, (int)0, null, (Function1)((Function1)new Function1<ExportedDeclaration, CharSequence>(this, indent){
                final /* synthetic */ ExportModelToTsDeclarations this$0;
                final /* synthetic */ String $indent;
                {
                    this.this$0 = $receiver;
                    this.$indent = $indent;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull ExportedDeclaration it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ExportModelToTsDeclarations.toTypeScript$default(this.this$0, it, this.$indent + "    ", null, 2, null) + '\n';
                }
            }), (int)24, null);
        } else if (exportedType instanceof ExportedType.IntersectionType) {
            string2 = ExportModelToTsDeclarations.toTypeScript$default(this, ((ExportedType.IntersectionType)$this$toTypeScript).getLhs(), indent, false, 2, null) + " & " + this.toTypeScript(((ExportedType.IntersectionType)$this$toTypeScript).getRhs(), indent, isInCommentContext);
        } else if (exportedType instanceof ExportedType.UnionType) {
            string2 = ExportModelToTsDeclarations.toTypeScript$default(this, ((ExportedType.UnionType)$this$toTypeScript).getLhs(), indent, false, 2, null) + " | " + this.toTypeScript(((ExportedType.UnionType)$this$toTypeScript).getRhs(), indent, isInCommentContext);
        } else if (exportedType instanceof ExportedType.LiteralType.StringLiteralType) {
            string2 = '\"' + (String)((ExportedType.LiteralType.StringLiteralType)$this$toTypeScript).getValue() + '\"';
        } else if (exportedType instanceof ExportedType.LiteralType.NumberLiteralType) {
            string2 = ((Number)((ExportedType.LiteralType.NumberLiteralType)$this$toTypeScript).getValue()).toString();
        } else if (exportedType instanceof ExportedType.ImplicitlyExportedType) {
            String typeString = this.toTypeScript(((ExportedType.ImplicitlyExportedType)$this$toTypeScript).getType(), "", true);
            string2 = isInCommentContext ? typeString : ExportModelToTsDeclarations.toTypeScript$default(this, ExportedType.Primitive.Any.INSTANCE, indent, false, 2, null) + "/* " + typeString + " */";
        } else if (exportedType instanceof ExportedType.TypeParameter) {
            string2 = ((ExportedType.TypeParameter)$this$toTypeScript).getConstraint() == null ? ((ExportedType.TypeParameter)$this$toTypeScript).getName() : ((ExportedType.TypeParameter)$this$toTypeScript).getName() + " extends " + this.toTypeScript(((ExportedType.TypeParameter)$this$toTypeScript).getConstraint(), indent, isInCommentContext);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    static /* synthetic */ String toTypeScript$default(ExportModelToTsDeclarations exportModelToTsDeclarations, ExportedType exportedType, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return exportModelToTsDeclarations.toTypeScript(exportedType, string2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean couldBeProperty(ExportedClass $this$couldBeProperty) {
        boolean bl;
        if (!($this$couldBeProperty instanceof ExportedObject)) return false;
        Iterable $this$all$iv = $this$couldBeProperty.getNestedClasses();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ExportedClass it = (ExportedClass)element$iv;
            boolean bl2 = false;
            if (!this.couldBeProperty(it)) return false;
            if (Intrinsics.areEqual((Object)it.getIr().getVisibility(), (Object)DescriptorVisibilities.PROTECTED)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public static final /* synthetic */ String access$toTypeScript(ExportModelToTsDeclarations $this, ExportedDeclaration $receiver, String indent, String prefix) {
        return $this.toTypeScript($receiver, indent, prefix);
    }

    public static final /* synthetic */ String access$getIndent(ExportModelToTsDeclarations $this, ModuleKind $receiver) {
        return $this.getIndent($receiver);
    }

    public static final /* synthetic */ String access$toTypeScript(ExportModelToTsDeclarations $this, ExportedParameter $receiver, String indent) {
        return $this.toTypeScript($receiver, indent);
    }

    public static final /* synthetic */ String access$toTypeScript(ExportModelToTsDeclarations $this, ExportedType $receiver, String indent, boolean isInCommentContext) {
        return $this.toTypeScript($receiver, indent, isInCommentContext);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleKind.values().length];
            try {
                nArray[ModuleKind.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.AMD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.COMMON_JS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.ES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleKind.UMD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

