/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ReifiedTypeParameterSubstitutionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Map<TypeParameterDescriptor, KotlinType> typeArguments2 = resolvedCall2.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments2.entrySet()) {
            PsiElement reportErrorOn;
            TypeParameterDescriptor parameter = entry.getKey();
            KotlinType argument = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescriptor = argument.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified() && !ReifiedTypeParameterSubstitutionChecker.isTypeParameterOfKotlinArray(parameter)) continue;
            KtTypeProjection typeProjection = (KtTypeProjection)CollectionsKt.getOrNull(resolvedCall2.getCall().getTypeArguments(), (int)parameter.getIndex());
            PsiElement psiElement = reportErrorOn = typeProjection != null ? typeProjection : reportOn;
            if (argumentDeclarationDescriptor instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)argumentDeclarationDescriptor).isReified()) {
                context.getTrace().report(Errors.TYPE_PARAMETER_AS_REIFIED.on(reportErrorOn, (TypeParameterDescriptor)argumentDeclarationDescriptor));
                continue;
            }
            if (!TypeUtilsKt.cannotBeReified(argument)) continue;
            context.getTrace().report(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION.on(reportErrorOn, argument));
        }
    }

    private static boolean isTypeParameterOfKotlinArray(@NotNull TypeParameterDescriptor parameter) {
        DeclarationDescriptor container2 = parameter.getContainingDeclaration();
        return container2 instanceof ClassDescriptor && KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)container2);
    }
}

