/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.modules.jmreport.common.constant.d;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuLowCodeModeInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuLowCodeModeInterceptor.class);
    public static final String LOW_CODE_MODE_DEV = "dev";
    public static final String LOW_CODE_MODE_PROD = "prod";
    public static final String LOW_CODE_MODE_PRODSF = "prodsf";
    @Resource
    private JmReportBaseConfig jmReportBaseConfig;
    @Resource
    private JmReportTokenClient jmReportTokenClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.jmReportBaseConfig == null) {
            this.jmReportBaseConfig = JimuSpringContextUtils.getBean(JmReportBaseConfig.class);
        }
        if (this.jmReportTokenClient == null) {
            this.jmReportTokenClient = JimuSpringContextUtils.getBean(JmReportTokenClient.class);
        }
        if (this.jmReportBaseConfig.getFirewall() != null && LOW_CODE_MODE_PROD.equals(this.jmReportBaseConfig.getFirewall().getLowCodeMode())) {
            String string = request.getRequestURI().substring(request.getContextPath().length());
            log.info("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u62e6\u622a\u8bf7\u6c42\u8def\u5f84\uff1a" + string);
            String string2 = this.jmReportTokenClient.getUsername();
            String[] stringArray = this.jmReportTokenClient.getRoles(request);
            boolean bl = org.jeecg.modules.jmreport.common.util.d.a(stringArray, d.a);
            if ("admin".equals(string2) || bl) {
                return true;
            }
            this.returnErrorMessage(response, "\u53d1\u5e03\u6a21\u5f0f");
            return false;
        }
        if (this.jmReportBaseConfig.getFirewall() != null && LOW_CODE_MODE_PRODSF.equals(this.jmReportBaseConfig.getFirewall().getLowCodeMode())) {
            String string = request.getRequestURI().substring(request.getContextPath().length());
            log.info("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u62e6\u622a\u8bf7\u6c42\u8def\u5f84\uff1a" + string);
            this.returnErrorMessage(response, "\u53d1\u5e03\u5b89\u5168\u6a21\u5f0f");
            return false;
        }
        return true;
    }

    private void returnErrorMessage(HttpServletResponse response, String content) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter printWriter = null;
        try {
            printWriter = response.getWriter();
            Result<Object> result = Result.error("\u5f53\u524d\u79ef\u6728\u5e73\u53f0\u6a21\u5f0f\u4e3a\uff0c" + content + "\u4e0d\u5141\u8bb8\u4f7f\u7528\u5728\u7ebf\u914d\u7f6e\uff01\uff01");
            printWriter.print(JSON.toJSON(result));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

