/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbSourceService;
import org.jeecg.modules.jmreport.desreport.service.IJmreportNoSqlService;
import org.jeecg.modules.jmreport.dyndb.utils.JmNosqlConst;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Component(value="jmreportNoSqlServiceImpl")
public class JmreportNoSqlServiceImpl
implements IJmreportNoSqlService {
    private static final Logger log = LoggerFactory.getLogger(JmreportNoSqlServiceImpl.class);
    public static final String COLON = ":";
    @Autowired
    private IJmReportDbSourceService jmReportDbSourceService;

    public List<Map<String, Object>> findList(String sql, String dbKey) {
        JmreportDynamicDataSourceVo dataSource = this.jmReportDbSourceService.getByDbKey(dbKey);
        List<Map<String, Object>> list = null;
        try {
            if (JmNosqlConst.MONGODB.equals(dataSource.getDbType())) {
                list = this.getListByMongodb(sql, dataSource);
            }
            if (JmNosqlConst.REDIS.equals(dataSource.getDbType())) {
                list = this.getListByRedis(sql, dataSource);
            }
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JimuReportException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getListByRedis(String sql, JmreportDynamicDataSourceVo dataSource) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String dbUrl = dataSource.getDbUrl();
        String dbPassword = dataSource.getDbPassword();
        Jedis jedis = null;
        jedis = dbUrl.indexOf(COLON) != -1 ? new Jedis(HostAndPort.parseString((String)dbUrl)) : new Jedis(dbUrl);
        try {
            if (dbPassword != null && !"".equals(dbPassword)) {
                jedis.auth(dbPassword);
            }
            log.debug("redis \u8fde\u63a5\u6210\u529f......");
            String json = jedis.get(sql);
            JSONArray jsonArray = JSONArray.parseArray((String)json);
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)jsonArray.get(i);
                list.add(map);
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e instanceof JedisConnectionException) {
                throw new JimuReportException("\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5redis\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            if (e instanceof NullPointerException) {
                throw new JimuReportException("\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6570\u636ekey\u548c\u8fd4\u56de\u683c\u5f0f\u662f\u5426\u6b63\u786e");
            }
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return list;
    }

    private List<Map<String, Object>> getListByMongodb(String sql, JmreportDynamicDataSourceVo dataSource) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            String res = this.getMogodbResult(dataSource, sql);
            if (res != null && !"".equals(res)) {
                JSONObject resultJson = JSONObject.parseObject((String)res);
                JSONArray jsonArray = resultJson.getJSONObject("cursor").getJSONArray("firstBatch");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Map map = (Map)jsonArray.get(i);
                    list.add(map);
                }
                if (list == null || list.size() == 0) {
                    throw new JimuReportException("\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u770bsql\u662f\u5426\u6b63\u786e\u6216\u662f\u5426\u5b58\u5728\u6570\u636e");
                }
                return list;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JimuReportException(e.getMessage());
        }
        return list;
    }

    private String getMogodbResult(JmreportDynamicDataSourceVo dataSource, String sql) {
        try (MongoClient client = null;){
            String res;
            String dbUsername = dataSource.getDbUsername();
            String dbPassword = dataSource.getDbPassword();
            String dbUrl = dataSource.getDbUrl();
            Map<String, String> dbInfoMap = this.getDbUrlInfo(dbUrl);
            MongoDatabase db = null;
            if (dbUrl.toLowerCase().contains("mongodb://")) {
                db = this.getMongoDataBase(dbUrl);
            } else {
                ArrayList<ServerAddress> adds = new ArrayList<ServerAddress>();
                ServerAddress serverAddress = new ServerAddress(dbInfoMap.get("host"), Integer.parseInt(dbInfoMap.get("port")));
                adds.add(serverAddress);
                MongoCredential credential = MongoCredential.createCredential((String)dbUsername, (String)dbInfoMap.get("dbName"), (char[])dbPassword.toCharArray());
                MongoClientSettings setting = MongoClientSettings.builder().credential(credential).applyToClusterSettings(builder -> builder.hosts(adds).serverSelectionTimeout(10L, TimeUnit.SECONDS).mode(ClusterConnectionMode.SINGLE).requiredClusterType(ClusterType.STANDALONE)).build();
                client = MongoClients.create((MongoClientSettings)setting);
                db = client.getDatabase(dbInfoMap.get("dbName"));
            }
            String string = res = JmreportNoSqlServiceImpl.mongodbCommandFind(db, sql);
            return string;
        }
    }

    private MongoDatabase getMongoDataBase(String dbUrl) {
        String dbName;
        MongoClient mongoClient = MongoClients.create((String)dbUrl);
        int dbIndex = dbUrl.lastIndexOf(47);
        String string = dbName = dbIndex != -1 ? dbUrl.substring(dbIndex + 1, dbUrl.indexOf("?")) : "";
        if (dbName == null || "".equals(dbName)) {
            int authSource = dbUrl.lastIndexOf("authSource");
            String string2 = dbName = dbIndex != -1 ? dbUrl.substring(authSource) : "";
            if (dbName.contains("&")) {
                dbName = dbName.substring(0, dbName.indexOf("&"));
            }
            dbName = dbName.replace("authSource=", "");
        }
        MongoIterable mongo = mongoClient.listDatabaseNames();
        mongo.first();
        MongoDatabase db = mongoClient.getDatabase(dbName);
        return db;
    }

    private Map<String, String> getDbUrlInfo(String dbUrl) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>(5);
        int index = dbUrl.lastIndexOf(58);
        int dbIndex = dbUrl.lastIndexOf(47);
        String host = index != -1 ? dbUrl.substring(0, index) : dbUrl;
        String port = index != -1 ? dbUrl.substring(index + 1, dbIndex) : "";
        String dbName = dbIndex != -1 ? dbUrl.substring(dbIndex + 1) : "";
        m.put("host", host);
        m.put("port", port);
        m.put("dbName", dbName);
        return m;
    }

    private static String mongodbCommandFind(MongoDatabase mongoDatabase, String queryGt) throws Exception {
        String queryReg = ".*\\.find\\(\\{(.*)\\}\\).*";
        boolean isMatch = Pattern.matches(queryReg, queryGt);
        if (!isMatch) {
            throw new Exception("\u6b64\u63a5\u53e3\u4ec5\u6267\u884c\u67e5\u8be2\u8bed\u53e5\uff0c\u4e14\u9700\u8981\u5236\u5b9a\u67e5\u8be2\u6761\u4ef6");
        }
        String tableRegExp = "getCollection\\('([\\w-_]+?)'\\)";
        String queryRegExp = "\\.find\\((.*?)\\)";
        String querySortRegExp = "\\.sort\\((.*?)\\)";
        String queryLimitRegExp = "\\.limit\\((.*?)\\)";
        String columnNameRegExp = "'(\\w+?)':1";
        String table = JmreportNoSqlServiceImpl.getWithRegExps(queryGt, tableRegExp).get(0);
        String query = JmreportNoSqlServiceImpl.getWithRegExps(queryGt, queryRegExp).get(0);
        String querySort = JmreportNoSqlServiceImpl.getWithRegExps(queryGt, querySortRegExp).size() > 0 ? JmreportNoSqlServiceImpl.getWithRegExps(queryGt, querySortRegExp).get(0) : null;
        String queryLimit = JmreportNoSqlServiceImpl.getWithRegExps(queryGt, queryLimitRegExp).size() > 0 ? JmreportNoSqlServiceImpl.getWithRegExps(queryGt, queryLimitRegExp).get(0) : null;
        String search = query.split("\\},")[0] + "}";
        Document doc = new Document();
        doc.append("find", (Object)table);
        if (query.split("\\},").length > 1) {
            String show = query.split("\\},")[1];
            List<String> columnNames = JmreportNoSqlServiceImpl.getWithRegExps(show, columnNameRegExp);
            Document projection = new Document();
            for (int i = 0; i < columnNames.size(); ++i) {
                projection.put(columnNames.get(i), (Object)1);
            }
            doc.append("projection", (Object)projection);
        }
        Document filter = Document.parse((String)search);
        doc.append("filter", (Object)filter);
        if (querySort != null && !"".equals(querySort)) {
            Document sort = Document.parse((String)querySort);
            doc.append("sort", (Object)sort);
        }
        if (queryLimit != null && !"".equals(queryLimit)) {
            doc.append("limit", (Object)Integer.valueOf(queryLimit));
        }
        Document result = mongoDatabase.runCommand((Bson)doc);
        return result.toJson();
    }

    private static List<String> getWithRegExps(String s, String regExp) {
        ArrayList<String> ss = new ArrayList<String>();
        Pattern r = Pattern.compile(regExp);
        Matcher m = r.matcher(s);
        while (m.find()) {
            ss.add(m.group(1));
        }
        return ss;
    }

    private String getDbType(String dbKey) {
        JmreportDynamicDataSourceVo dataSourceVo = this.jmReportDbSourceService.getByDbKey(dbKey);
        return dataSourceVo.getDbType();
    }

    public Boolean testConnection(JmreportDynamicDataSourceVo dbSource) {
        Boolean b = true;
        try {
            String dbUrl = dbSource.getDbUrl();
            String dbPassword = dbSource.getDbPassword();
            if (JmNosqlConst.REDIS.equals(dbSource.getDbType())) {
                b = JmreportNoSqlServiceImpl.getRedisIsOk(dbUrl, dbPassword);
            }
            if (JmNosqlConst.MONGODB.equals(dbSource.getDbType())) {
                b = this.getMogodbIsOk(dbSource);
            }
        }
        catch (JimuReportException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JimuReportException(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean getRedisIsOk(String dbUrl, String dbPassword) {
        Boolean result = true;
        try (Jedis jedis = null;){
            String ping;
            jedis = dbUrl.indexOf(COLON) != -1 ? new Jedis(HostAndPort.parseString((String)dbUrl)) : new Jedis(dbUrl);
            if (dbPassword != null && !"".equals(dbPassword)) {
                jedis.auth(dbPassword);
            }
            if ("PONG".equalsIgnoreCase(ping = jedis.ping())) {
                log.debug("redis\u7f13\u5b58\u6709\u6548\uff01" + ping);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getMogodbIsOk(JmreportDynamicDataSourceVo dataSource) {
        boolean b = true;
        try (MongoClient client = null;){
            String dbUrl = dataSource.getDbUrl();
            String dbUsername = dataSource.getDbUsername();
            String dbPassword = dataSource.getDbPassword();
            Map<String, String> m = this.getDbUrlInfo(dbUrl);
            if (dbUrl.toLowerCase().contains("mongodb://")) {
                this.getMongoDataBase(dbUrl);
                b = true;
            } else {
                ArrayList<ServerAddress> adds = new ArrayList<ServerAddress>();
                ServerAddress serverAddress = new ServerAddress(m.get("host"), Integer.parseInt(m.get("port")));
                adds.add(serverAddress);
                MongoCredential credential = MongoCredential.createCredential((String)dbUsername, (String)m.get("dbName"), (char[])dbPassword.toCharArray());
                MongoClientSettings setting = MongoClientSettings.builder().credential(credential).applyToClusterSettings(builder -> builder.hosts(adds).mode(ClusterConnectionMode.SINGLE).requiredClusterType(ClusterType.STANDALONE)).build();
                client = MongoClients.create((MongoClientSettings)setting);
                MongoIterable mongoClient = client.listDatabaseNames();
                mongoClient.first();
            }
        }
        return b;
    }
}

