/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.html.HtmlToExcelServer;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;

public final class HtmlToExcelUtil {
    private HtmlToExcelUtil() {
    }

    public static Workbook htmlToExcel(String html, ExcelType type) {
        Object workbook = null;
        workbook = ExcelType.HSSF.equals((Object)type) ? new HSSFWorkbook() : new XSSFWorkbook();
        new HtmlToExcelServer().createSheet(html, (Workbook)workbook);
        return workbook;
    }

    public static Workbook htmlToExcel(InputStream is, ExcelType type) {
        try {
            return HtmlToExcelUtil.htmlToExcel(new String(IOUtils.toByteArray((InputStream)is)), type);
        }
        catch (IOException e) {
            throw new ExcelExportException(ExcelExportEnum.HTML_ERROR, (Throwable)e);
        }
    }
}

