/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.stream.JsonGrammarAnalyzer;
import org.jboss.dmr.stream.ModelEvent;
import org.jboss.dmr.stream.ModelException;
import org.jboss.dmr.stream.ModelReader;
import org.jboss.dmr.stream.Utils;

final class JsonReaderImpl
implements ModelReader {
    private static final char[] INFINITY = "Infinity".toCharArray();
    private static final char[] NAN = "NaN".toCharArray();
    private static final char[] NULL = "null".toCharArray();
    private static final char[] TRUE = "true".toCharArray();
    private static final char[] FALSE = "false".toCharArray();
    private final Reader in;
    private final JsonGrammarAnalyzer analyzer;
    private char[] buffer = new char[1024];
    private int position;
    private int limit;
    private int numberOffset;
    private int numberLength;
    private int stringOffset;
    private int stringLength;
    private byte[] bytesValue;
    private ModelType typeValue;
    private int intValue;
    private long longValue;
    private double doubleValue;
    private BigInteger bigIntegerValue;
    private BigDecimal bigDecimalValue;
    private boolean booleanValue;
    private String stringValue;
    private boolean closed;
    private boolean stringReadInAdvance;

    JsonReaderImpl(Reader in) {
        this.in = in;
        this.analyzer = new JsonGrammarAnalyzer();
    }

    @Override
    public void close() throws ModelException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.analyzer.finished) {
            throw this.analyzer.newModelException("Uncomplete DMR stream have been read");
        }
    }

    @Override
    public String getString() {
        if (!this.isCurrentEvent(ModelEvent.STRING)) {
            throw new IllegalStateException("Current event isn't string");
        }
        return this.stringValue;
    }

    @Override
    public int getInt() {
        if (!this.isCurrentEvent(ModelEvent.INT)) {
            throw new IllegalStateException("Current event isn't int");
        }
        return this.intValue;
    }

    @Override
    public long getLong() {
        if (!this.isCurrentEvent(ModelEvent.LONG)) {
            throw new IllegalStateException("Current event isn't long");
        }
        return this.longValue;
    }

    @Override
    public double getDouble() {
        if (!this.isCurrentEvent(ModelEvent.DOUBLE)) {
            throw new IllegalStateException("Current event isn't double");
        }
        return this.doubleValue;
    }

    @Override
    public BigInteger getBigInteger() {
        if (!this.isCurrentEvent(ModelEvent.BIG_INTEGER)) {
            throw new IllegalStateException("Current event isn't big integer");
        }
        return this.bigIntegerValue;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (!this.isCurrentEvent(ModelEvent.BIG_DECIMAL)) {
            throw new IllegalStateException("Current event isn't big decimal");
        }
        return this.bigDecimalValue;
    }

    @Override
    public byte[] getBytes() {
        if (!this.isCurrentEvent(ModelEvent.BYTES)) {
            throw new IllegalStateException("Current event isn't bytes");
        }
        return this.bytesValue;
    }

    @Override
    public String getExpression() {
        if (!this.isCurrentEvent(ModelEvent.EXPRESSION)) {
            throw new IllegalStateException("Current event isn't expression");
        }
        return this.stringValue;
    }

    @Override
    public ModelType getType() {
        if (!this.isCurrentEvent(ModelEvent.TYPE)) {
            throw new IllegalStateException("Current event isn't type");
        }
        return this.typeValue;
    }

    @Override
    public boolean getBoolean() {
        if (!this.isCurrentEvent(ModelEvent.BOOLEAN)) {
            throw new IllegalStateException("Current event isn't boolean");
        }
        return this.booleanValue;
    }

    @Override
    public boolean isListEnd() {
        return this.isCurrentEvent(ModelEvent.LIST_END);
    }

    @Override
    public boolean isListStart() {
        return this.isCurrentEvent(ModelEvent.LIST_START);
    }

    @Override
    public boolean isObjectEnd() {
        return this.isCurrentEvent(ModelEvent.OBJECT_END);
    }

    @Override
    public boolean isObjectStart() {
        return this.isCurrentEvent(ModelEvent.OBJECT_START);
    }

    @Override
    public boolean isPropertyEnd() {
        return this.isCurrentEvent(ModelEvent.PROPERTY_END);
    }

    @Override
    public boolean isPropertyStart() {
        return this.isCurrentEvent(ModelEvent.PROPERTY_START);
    }

    @Override
    public boolean isString() {
        return this.isCurrentEvent(ModelEvent.STRING);
    }

    @Override
    public boolean isInt() {
        return this.isCurrentEvent(ModelEvent.INT);
    }

    @Override
    public boolean isLong() {
        return this.isCurrentEvent(ModelEvent.LONG);
    }

    @Override
    public boolean isDouble() {
        return this.isCurrentEvent(ModelEvent.DOUBLE);
    }

    @Override
    public boolean isBigInteger() {
        return this.isCurrentEvent(ModelEvent.BIG_INTEGER);
    }

    @Override
    public boolean isBigDecimal() {
        return this.isCurrentEvent(ModelEvent.BIG_DECIMAL);
    }

    @Override
    public boolean isBytes() {
        return this.isCurrentEvent(ModelEvent.BYTES);
    }

    @Override
    public boolean isExpression() {
        return this.isCurrentEvent(ModelEvent.EXPRESSION);
    }

    @Override
    public boolean isType() {
        return this.isCurrentEvent(ModelEvent.TYPE);
    }

    @Override
    public boolean isBoolean() {
        return this.isCurrentEvent(ModelEvent.BOOLEAN);
    }

    @Override
    public boolean isUndefined() {
        return this.isCurrentEvent(ModelEvent.UNDEFINED);
    }

    private boolean isCurrentEvent(ModelEvent event) {
        this.ensureOpen();
        return this.analyzer.currentEvent == event;
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        return !this.analyzer.finished;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ModelEvent next() throws IOException, ModelException {
        this.ensureOpen();
        if (this.analyzer.finished) {
            throw new IllegalStateException("No more DMR tokens available");
        }
        boolean assertEmptyStream = true;
        try {
            if (this.stringReadInAdvance) {
                this.stringReadInAdvance = false;
                this.analyzer.putString();
                ModelEvent modelEvent = this.analyzer.currentEvent;
                return modelEvent;
            }
            block36: while (true) {
                this.ensureBufferAccess(1);
                int currentChar = this.buffer[this.position++];
                switch (currentChar) {
                    case 34: {
                        this.analyzer.putString();
                        this.readString();
                        this.stringValue = new String(this.buffer, this.stringOffset, this.stringLength);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 58: {
                        this.analyzer.putColon();
                        continue block36;
                    }
                    case 44: {
                        this.analyzer.putComma();
                        continue block36;
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int radix = 10;
                        if (currentChar == 43 || currentChar == 45) {
                            --this.position;
                            this.ensureBufferAccess(2);
                            ++this.position;
                            if (this.buffer[this.position] == 'I') {
                                this.readString(INFINITY);
                                this.analyzer.putNumber(ModelEvent.DOUBLE);
                                this.doubleValue = currentChar == 43 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                                ModelEvent modelEvent = this.analyzer.currentEvent;
                                return modelEvent;
                            }
                            if (this.buffer[this.position] == 'N') {
                                this.readString(NAN);
                                this.analyzer.putNumber(ModelEvent.DOUBLE);
                                this.doubleValue = Double.NaN;
                                ModelEvent modelEvent = this.analyzer.currentEvent;
                                return modelEvent;
                            }
                            if (this.buffer[this.position] == '0') {
                                --this.position;
                                if (this.ensureBufferAccessNoFail(3)) {
                                    if (this.buffer[this.position + 2] == 'x') {
                                        radix = 16;
                                        this.position += 2;
                                    } else if (Utils.isDigit(this.buffer[this.position + 2])) {
                                        radix = 8;
                                        ++this.position;
                                    }
                                }
                                ++this.position;
                            } else if (!Utils.isNumberChar(this.buffer[this.position])) {
                                throw this.newModelException("Unexpected first character '" + this.buffer[this.position] + "' while reading DMR Infinity or NaN or number token");
                            }
                        }
                        if (currentChar == 48) {
                            --this.position;
                            if (this.ensureBufferAccessNoFail(2)) {
                                if (this.buffer[this.position + 1] == 'x') {
                                    radix = 16;
                                    ++this.position;
                                } else if (Utils.isDigit(this.buffer[this.position + 1])) {
                                    radix = 8;
                                }
                            }
                            ++this.position;
                        }
                        if (radix == 10) {
                            --this.position;
                        }
                        this.readNumber(radix > 10);
                        if (this.isDecimalString()) {
                            try {
                                this.analyzer.putNumber(ModelEvent.BIG_DECIMAL);
                                this.bigDecimalValue = new BigDecimal(new String(this.buffer, this.numberOffset, this.numberLength));
                            }
                            catch (NumberFormatException nfe) {
                                throw this.newModelException("Incorrect decimal value", nfe);
                            }
                        }
                        try {
                            BigInteger bigIntegerValue = radix == 10 ? new BigInteger(new String(this.buffer, this.numberOffset, this.numberLength), radix) : new BigInteger((currentChar == 45 ? "-" : "+") + new String(this.buffer, this.numberOffset, this.numberLength), radix);
                            if (bigIntegerValue.bitLength() <= 31) {
                                this.analyzer.putNumber(ModelEvent.INT);
                                this.intValue = bigIntegerValue.intValue();
                            } else if (bigIntegerValue.bitLength() <= 63) {
                                this.analyzer.putNumber(ModelEvent.LONG);
                                this.longValue = bigIntegerValue.longValue();
                            } else {
                                this.analyzer.putNumber(ModelEvent.BIG_INTEGER);
                                this.bigIntegerValue = bigIntegerValue;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            throw this.newModelException("Incorrect integer value", nfe);
                        }
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 73: {
                        --this.position;
                        this.readString(INFINITY);
                        this.analyzer.putNumber(ModelEvent.DOUBLE);
                        this.doubleValue = Double.POSITIVE_INFINITY;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 78: {
                        --this.position;
                        this.readString(NAN);
                        this.analyzer.putNumber(ModelEvent.DOUBLE);
                        this.doubleValue = Double.NaN;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 102: 
                    case 116: {
                        this.analyzer.putBoolean();
                        --this.position;
                        this.booleanValue = currentChar == 116;
                        this.readString(this.booleanValue ? TRUE : FALSE);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 110: {
                        this.analyzer.putUndefined();
                        --this.position;
                        this.readString(NULL);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 123: {
                        this.processWhitespaces();
                        int n = currentChar = this.position < this.limit ? this.buffer[this.position++] : this.read();
                        if (currentChar == 34) {
                            this.readString();
                            this.stringValue = new String(this.buffer, this.stringOffset, this.stringLength);
                            if ("TYPE_MODEL_VALUE".equals(this.stringValue)) {
                                this.processWhitespaces();
                                this.readType();
                                this.analyzer.putType();
                            } else if ("BYTES_VALUE".equals(this.stringValue)) {
                                this.processWhitespaces();
                                this.readBytes();
                                this.analyzer.putBytes();
                            } else if ("EXPRESSION_VALUE".equals(this.stringValue)) {
                                this.processWhitespaces();
                                this.readExpression();
                                this.analyzer.putExpression();
                            } else {
                                this.stringReadInAdvance = true;
                                this.analyzer.putObjectStart();
                            }
                        } else {
                            if (currentChar != -1) {
                                --this.position;
                            }
                            this.analyzer.putObjectStart();
                        }
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 91: {
                        this.analyzer.putListStart();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 125: {
                        this.analyzer.putObjectEnd();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 93: {
                        this.analyzer.putListEnd();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                }
                if (!Utils.isWhitespace(currentChar)) throw this.newModelException("Unexpected character '" + (char)currentChar + "' while reading DMR stream");
                this.processWhitespaces();
                continue;
                break;
            }
            catch (Throwable t) {
                assertEmptyStream = false;
                throw t;
            }
        }
        finally {
            if (this.analyzer.finished && assertEmptyStream) {
                this.processWhitespaces();
                if (this.read() != -1) {
                    throw new ModelException("Unexpected content following the DMR stream");
                }
            }
        }
    }

    private void processWhitespaces() throws IOException {
        char currentChar;
        do {
            if (this.position == this.limit) {
                this.limit = 0;
                this.position = 0;
                this.fillBuffer();
                if (this.position != this.limit) continue;
                return;
            }
            if (this.position != this.limit - 1) continue;
            this.buffer[0] = this.buffer[this.position];
            this.limit = 1;
            this.position = 0;
            this.fillBuffer();
        } while (Utils.isWhitespace(currentChar = this.buffer[this.position++]));
        --this.position;
    }

    private void ensureData() throws IOException {
        if (this.position == this.limit) {
            if (this.limit == this.buffer.length) {
                this.limit = 0;
                this.position = 0;
            }
            this.fillBuffer();
        }
    }

    private void ensureBufferAccess(int charsCount) throws IOException, ModelException {
        if (this.position + charsCount <= this.limit) {
            return;
        }
        if (this.position <= this.limit) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.limit - this.position);
            this.limit -= this.position;
            this.position = 0;
        }
        this.fillBuffer();
        if (this.position + charsCount > this.limit) {
            throw this.newModelException("Unexpected EOF while reading DMR stream");
        }
    }

    private boolean ensureBufferAccessNoFail(int charsCount) throws IOException, ModelException {
        if (this.position + charsCount <= this.limit) {
            return true;
        }
        if (this.position <= this.limit) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.limit - this.position);
            this.limit -= this.position;
            this.position = 0;
        }
        this.fillBuffer();
        return this.position + charsCount <= this.limit;
    }

    private void fillBuffer() throws IOException {
        do {
            int read;
            if ((read = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) == -1) {
                return;
            }
            this.limit += read;
        } while (this.limit != this.buffer.length);
    }

    private int read() throws IOException {
        this.ensureData();
        return this.position < this.limit ? this.buffer[this.position++] : -1;
    }

    private void readString() throws IOException, ModelException {
        boolean escaped = false;
        this.stringLength = 0;
        boolean copy = false;
        do {
            if (this.stringLength == 0) {
                this.stringOffset = this.position;
            }
            while (this.position != this.limit) {
                char currentChar = this.buffer[this.position++];
                if (escaped) {
                    copy = true;
                    if (currentChar == 'b') {
                        this.buffer[this.stringOffset + this.stringLength++] = 8;
                    } else if (currentChar == 'f') {
                        this.buffer[this.stringOffset + this.stringLength++] = 12;
                    } else if (currentChar == 'n') {
                        this.buffer[this.stringOffset + this.stringLength++] = 10;
                    } else if (currentChar == 'r') {
                        this.buffer[this.stringOffset + this.stringLength++] = 13;
                    } else if (currentChar == 't') {
                        this.buffer[this.stringOffset + this.stringLength++] = 9;
                    } else if (currentChar == 'u') {
                        if (this.limit - this.position >= 4) {
                            try {
                                this.buffer[this.stringOffset + this.stringLength++] = (char)Integer.parseInt(new String(this.buffer, this.position, 4), 16);
                            }
                            catch (NumberFormatException e) {
                                throw this.newModelException("Invalid DMR unicode sequence. Expecting 4 hexadecimal digits but got '" + new String(this.buffer, this.position, 4) + "'");
                            }
                            this.position += 4;
                        } else {
                            if (this.stringOffset != 0) {
                                if (this.stringLength > 0) {
                                    System.arraycopy(this.buffer, this.stringOffset, this.buffer, 0, this.stringLength);
                                }
                                this.position = this.stringLength;
                                this.limit = this.stringLength;
                                this.stringOffset = 0;
                            }
                            while (this.limit + 4 > this.buffer.length) {
                                this.doubleBuffer();
                            }
                            this.fillBuffer();
                            if (this.limit - this.position < 4) {
                                throw this.newModelException("Unexpected EOF while reading DMR stream");
                            }
                            try {
                                this.buffer[this.stringOffset + this.stringLength++] = (char)Integer.parseInt(new String(this.buffer, this.position, 4), 16);
                            }
                            catch (NumberFormatException e) {
                                throw this.newModelException("Invalid DMR unicode sequence. Expecting 4 hexadecimal digits but got '" + new String(this.buffer, this.position, 4) + "'");
                            }
                            this.position += 4;
                        }
                    } else {
                        this.buffer[this.stringOffset + this.stringLength++] = currentChar;
                    }
                    escaped = false;
                    continue;
                }
                if (currentChar == '\"') {
                    return;
                }
                if (currentChar == '\\') {
                    escaped = true;
                    continue;
                }
                if (Utils.isControl(currentChar)) {
                    throw this.newModelException("Unexpected control character '" + currentChar + "' while reading DMR string");
                }
                if (copy) {
                    this.buffer[this.stringOffset + this.stringLength] = currentChar;
                }
                ++this.stringLength;
            }
            if (this.stringOffset != 0 && this.stringLength > 0) {
                System.arraycopy(this.buffer, this.stringOffset, this.buffer, 0, this.stringLength);
                this.position = this.stringLength;
                this.limit = this.stringLength;
                this.stringOffset = 0;
            } else if (this.stringOffset == 0 && this.limit == this.buffer.length) {
                this.doubleBuffer();
            }
            this.ensureData();
        } while (this.position != this.limit);
        throw this.newModelException("Unexpected EOF while reading DMR stream");
    }

    private void readString(char[] expected) throws IOException, ModelException {
        int i;
        if (this.position < this.limit - expected.length + 1) {
            for (i = 0; i < expected.length; ++i) {
                if (this.buffer[this.position++] == expected[i]) continue;
                throw this.newModelException("Unexpected character '" + this.buffer[this.position - 1] + "' while reading DMR " + new String(expected) + " token");
            }
        } else {
            while (true) {
                if (this.position < this.limit && i != expected.length) {
                    if (this.buffer[this.position++] == expected[i++]) continue;
                    throw this.newModelException("Unexpected character '" + this.buffer[this.position - 1] + "' while reading DMR " + new String(expected) + " token");
                }
                if (i == expected.length) {
                    return;
                }
                this.ensureData();
                if (this.position == this.limit) break;
            }
            throw this.newModelException("Unexpected EOF while reading DMR stream");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readNumber(boolean hexed) throws IOException, ModelException {
        this.numberOffset = this.position;
        while (true) {
            if (this.position < this.limit) {
                if (hexed ? Utils.isHexNumberChar(this.buffer[this.position++]) : Utils.isNumberChar(this.buffer[this.position++])) continue;
                --this.position;
            }
            this.numberLength = this.position - this.numberOffset;
            if (this.position < this.limit) return;
            if (this.numberOffset != 0) {
                System.arraycopy(this.buffer, this.numberOffset, this.buffer, 0, this.numberLength);
                this.position = this.numberLength;
                this.limit = this.numberLength;
                this.numberOffset = 0;
            } else if (this.limit == this.buffer.length) {
                this.doubleBuffer();
            }
            this.ensureData();
            if (this.position == this.limit) return;
        }
    }

    private boolean isDecimalString() {
        int numberLimit = this.numberOffset + this.numberLength;
        for (int i = this.numberOffset; i < numberLimit; ++i) {
            if (this.buffer[i] != '.') continue;
            return true;
        }
        return false;
    }

    private void doubleBuffer() {
        char[] oldData = this.buffer;
        this.buffer = new char[oldData.length * 2];
        System.arraycopy(oldData, 0, this.buffer, 0, oldData.length);
    }

    private ModelException newModelException(String message) throws ModelException {
        throw this.analyzer.newModelException(message);
    }

    private ModelException newModelException(String message, Throwable t) throws ModelException {
        throw this.analyzer.newModelException(message, t);
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("DMR reader have been closed");
        }
    }

    private void readType() throws IOException, ModelException {
        this.ensureBufferAccess(1);
        char currentChar = this.buffer[this.position++];
        if (currentChar != ':') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR type value");
        }
        this.processWhitespaces();
        this.ensureBufferAccess(1);
        currentChar = this.buffer[this.position++];
        if (currentChar != '\"') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR type value");
        }
        this.readString();
        try {
            this.typeValue = ModelType.valueOf(new String(this.buffer, this.stringOffset, this.stringLength));
        }
        catch (IllegalArgumentException e) {
            throw this.newModelException(e.getMessage(), e);
        }
        this.processWhitespaces();
        this.ensureBufferAccess(1);
        currentChar = this.buffer[this.position++];
        if (currentChar != '}') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR type value");
        }
    }

    private void readBytes() throws IOException, ModelException {
        this.ensureBufferAccess(1);
        char currentChar = this.buffer[this.position++];
        if (currentChar != ':') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR bytes value");
        }
        this.processWhitespaces();
        this.ensureBufferAccess(1);
        currentChar = this.buffer[this.position++];
        if (currentChar != '\"') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR bytes value");
        }
        this.base64Canonicalize();
        this.base64Decode();
        this.processWhitespaces();
        this.ensureBufferAccess(1);
        currentChar = this.buffer[this.position++];
        if (currentChar != '}') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR bytes value");
        }
    }

    private void base64Canonicalize() throws IOException, ModelException {
        boolean escaped = false;
        this.stringLength = 0;
        boolean copy = false;
        do {
            if (this.stringLength == 0) {
                this.stringOffset = this.position;
            }
            while (this.position != this.limit) {
                char currentChar = this.buffer[this.position++];
                if (escaped) {
                    copy = true;
                    if (currentChar != 'n' && currentChar != 'r') {
                        throw this.newModelException("Unexpected character '" + currentChar + "' after escape character while reading DMR base64 string");
                    }
                    escaped = false;
                    continue;
                }
                if (currentChar == '\"') {
                    return;
                }
                if (currentChar == '\\') {
                    escaped = true;
                    continue;
                }
                if (!Utils.isBase64Char(currentChar)) {
                    throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR base64 string");
                }
                if (copy) {
                    this.buffer[this.stringOffset + this.stringLength] = currentChar;
                }
                ++this.stringLength;
            }
            if (this.stringOffset != 0 && this.stringLength > 0) {
                System.arraycopy(this.buffer, this.stringOffset, this.buffer, 0, this.stringLength);
                this.position = this.stringLength;
                this.limit = this.stringLength;
                this.stringOffset = 0;
            } else if (this.stringOffset == 0 && this.limit == this.buffer.length) {
                this.doubleBuffer();
            }
            this.ensureData();
        } while (this.position != this.limit);
        throw this.newModelException("Unexpected EOF while reading DMR stream");
    }

    private void base64Decode() throws IOException, ModelException {
        if (this.stringLength == 0) {
            this.bytesValue = Utils.EMPTY_BYTES;
            return;
        }
        if (this.stringLength % 4 != 0) {
            throw this.newModelException("Encoded base64 value is not dividable by 4");
        }
        int paddingSize = 0;
        for (int i = 1; i <= 2; ++i) {
            if (this.buffer[this.stringOffset + this.stringLength - i] != '=') continue;
            paddingSize = i;
        }
        this.bytesValue = new byte[this.stringLength / 4 * 3 - paddingSize];
        int j = 0;
        int[] b = new int[4];
        for (int i = 0; i < this.stringLength; i += 4) {
            b[0] = Utils.BASE64_DEC_TABLE[this.buffer[this.stringOffset + i]];
            b[1] = Utils.BASE64_DEC_TABLE[this.buffer[this.stringOffset + i + 1]];
            b[2] = Utils.BASE64_DEC_TABLE[this.buffer[this.stringOffset + i + 2]];
            b[3] = Utils.BASE64_DEC_TABLE[this.buffer[this.stringOffset + i + 3]];
            this.bytesValue[j++] = (byte)(b[0] << 2 | b[1] >> 4);
            if (b[2] == -1) continue;
            this.bytesValue[j++] = (byte)(b[1] << 4 | b[2] >> 2);
            if (b[3] == -1) continue;
            this.bytesValue[j++] = (byte)(b[2] << 6 | b[3]);
        }
    }

    private void readExpression() throws IOException, ModelException {
        this.ensureBufferAccess(1);
        char currentChar = this.buffer[this.position++];
        if (currentChar != ':') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR expression value");
        }
        this.processWhitespaces();
        this.ensureBufferAccess(1);
        currentChar = this.buffer[this.position++];
        if (currentChar != '\"') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR expression value");
        }
        this.readString();
        this.stringValue = new String(this.buffer, this.stringOffset, this.stringLength);
        this.processWhitespaces();
        this.ensureBufferAccess(1);
        currentChar = this.buffer[this.position++];
        if (currentChar != '}') {
            throw this.newModelException("Unexpected character '" + currentChar + "' while reading DMR expression value");
        }
    }
}

