/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Formatter;
import org.jasig.cas.monitor.CacheStatistics;

public class SimpleCacheStatistics
implements CacheStatistics {
    private static final double BYTES_PER_MB = 1048510.0;
    private static final int PERCENTAGE_VALUE = 100;
    private final long size;
    private final long capacity;
    private final long evictions;
    private String name;

    public SimpleCacheStatistics(long size, long capacity, long evictions) {
        this.size = size;
        this.capacity = capacity;
        this.evictions = evictions;
    }

    public SimpleCacheStatistics(long size, long capacity, long evictions, String name) {
        this.size = size;
        this.capacity = capacity;
        this.evictions = evictions;
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getEvictions() {
        return this.evictions;
    }

    public int getPercentFree() {
        if (this.capacity == 0L) {
            return 0;
        }
        return (int)((this.capacity - this.size) * 100L / this.capacity);
    }

    public void toString(StringBuilder builder) {
        if (this.name != null) {
            builder.append(this.name).append(':');
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Formatter formatter = new Formatter(builder);){
            formatter.format("%.2f", (double)this.size / 1048510.0);
            builder.append("MB used, ");
            builder.append(this.getPercentFree()).append("% free, ");
            builder.append(this.evictions).append(" evictions");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getName() {
        return this.name;
    }
}

