/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.CacheStatistics;
import org.jasig.cas.monitor.CacheStatus;
import org.jasig.cas.monitor.StatusCode;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractCacheMonitor
extends AbstractNamedMonitor<CacheStatus> {
    public static final int DEFAULT_WARN_FREE_THRESHOLD = 10;
    public static final long DEFAULT_EVICTION_THRESHOLD = 0L;
    @Value(value="${cache.monitor.warn.free.threshold:10}")
    private int warnFreeThreshold = 10;
    @Value(value="${cache.monitor.eviction.threshold:0}")
    private long evictionThreshold = 0L;

    public void setWarnFreeThreshold(int percent) {
        this.warnFreeThreshold = percent;
    }

    public void setEvictionThreshold(long count) {
        this.evictionThreshold = count;
    }

    public CacheStatus observe() {
        CacheStatus status;
        try {
            CacheStatistics[] statistics = this.getStatistics();
            if (statistics == null || statistics.length == 0) {
                return new CacheStatus(StatusCode.ERROR, "Cache statistics not available.", new CacheStatistics[0]);
            }
            StatusCode overall = StatusCode.OK;
            CacheStatistics[] cacheStatisticsArray = statistics;
            int n = statistics.length;
            int n2 = 0;
            while (n2 < n) {
                CacheStatistics stats = cacheStatisticsArray[n2];
                StatusCode code = this.status(stats);
                if (code.value() > overall.value()) {
                    overall = code;
                }
                ++n2;
            }
            status = new CacheStatus(overall, null, statistics);
        }
        catch (Exception e) {
            status = new CacheStatus(e);
        }
        return status;
    }

    protected abstract CacheStatistics[] getStatistics();

    protected StatusCode status(CacheStatistics statistics) {
        StatusCode code = statistics.getEvictions() > this.evictionThreshold ? StatusCode.WARN : (statistics.getPercentFree() < this.warnFreeThreshold ? StatusCode.WARN : StatusCode.OK);
        return code;
    }
}

