/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;

public final class CasDelegatingLogger
extends MarkerIgnoringBase
implements Serializable {
    private static final long serialVersionUID = 6182834493563598289L;
    private static final Pattern TICKET_ID_PATTERN = Pattern.compile("(TGT|PGTIOU|PGT)(-)*(\\w)*(-)*(\\w)*");
    private static final int VISIBLE_ID_TAIL_LENGTH = 10;
    private final Logger delegate;

    private CasDelegatingLogger() {
        this.delegate = null;
    }

    public CasDelegatingLogger(Logger delegate) {
        this.delegate = delegate;
    }

    private String manipulateLogMessage(String msg) {
        return this.removeTicketId(msg);
    }

    private Object[] manipulateLogArguments(Object ... args) {
        Object[] out = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            out[i] = args[i] != null ? this.removeTicketId(args[i].toString()) : null;
        }
        return out;
    }

    private String removeTicketId(String msg) {
        String modifiedMessage = msg;
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            Matcher matcher = TICKET_ID_PATTERN.matcher(msg);
            while (matcher.find()) {
                String match = matcher.group();
                String newId = matcher.group(1) + '-' + StringUtils.repeat((String)"*", (int)(match.length() - 10)) + StringUtils.right((String)match, (int)10);
                modifiedMessage = modifiedMessage.replaceAll(match, newId);
            }
        }
        return modifiedMessage;
    }

    private String getExceptionToLog(String msg, Throwable t) {
        StringWriter sW = new StringWriter();
        PrintWriter w = new PrintWriter(sW);
        w.println(this.manipulateLogMessage(msg));
        if (t != null) {
            t.printStackTrace(w);
        }
        String log = sW.getBuffer().toString();
        return this.manipulateLogMessage(log);
    }

    public void trace(String format, Object arg) {
        this.delegate.trace(this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.delegate.trace(this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void trace(String format, Object ... arguments) {
        this.delegate.trace(this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void trace(String msg, Throwable t) {
        this.delegate.trace(this.getExceptionToLog(msg, t));
    }

    public void trace(Marker marker, String msg) {
        this.delegate.trace(marker, this.manipulateLogMessage(msg));
    }

    public void trace(Marker marker, String format, Object arg) {
        this.delegate.trace(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.trace(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.delegate.trace(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.delegate.trace(marker, this.getExceptionToLog(msg, t));
    }

    public void trace(String msg) {
        this.delegate.trace(this.manipulateLogMessage(msg));
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public void debug(String format, Object arg) {
        this.delegate.debug(this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.delegate.debug(this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        this.delegate.debug(this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void debug(String msg, Throwable t) {
        this.delegate.debug(this.getExceptionToLog(msg, t));
    }

    public void debug(Marker marker, String msg) {
        this.delegate.debug(marker, this.manipulateLogMessage(msg));
    }

    public void debug(Marker marker, String format, Object arg) {
        this.delegate.debug(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.debug(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.delegate.debug(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.delegate.debug(marker, this.getExceptionToLog(msg, t));
    }

    public void debug(String msg) {
        this.delegate.debug(this.manipulateLogMessage(msg));
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String format, Object arg) {
        this.delegate.info(this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.delegate.info(this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void info(String format, Object ... arguments) {
        this.delegate.info(this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void info(String msg, Throwable t) {
        this.delegate.info(this.getExceptionToLog(msg, t));
    }

    public void info(Marker marker, String msg) {
        this.delegate.info(marker, this.manipulateLogMessage(msg));
    }

    public void info(Marker marker, String format, Object arg) {
        this.delegate.info(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.info(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.delegate.info(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.delegate.info(marker, this.getExceptionToLog(msg, t));
    }

    public void info(String msg) {
        this.delegate.info(this.manipulateLogMessage(msg));
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void warn(String format, Object arg) {
        this.delegate.warn(this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.delegate.warn(this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void warn(String format, Object ... arguments) {
        this.delegate.warn(this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void warn(String msg, Throwable t) {
        this.delegate.warn(this.getExceptionToLog(msg, t));
    }

    public void warn(Marker marker, String msg) {
        this.delegate.warn(marker, this.manipulateLogMessage(msg));
    }

    public void warn(Marker marker, String format, Object arg) {
        this.delegate.warn(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.warn(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.delegate.warn(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.delegate.warn(marker, this.getExceptionToLog(msg, t));
    }

    public void warn(String msg) {
        this.delegate.warn(this.manipulateLogMessage(msg));
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public void error(String format, Object arg) {
        this.delegate.error(this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.delegate.error(this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        this.delegate.error(this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void error(String msg, Throwable t) {
        this.delegate.error(this.getExceptionToLog(msg, t));
    }

    public void error(Marker marker, String msg) {
        this.delegate.error(marker, this.manipulateLogMessage(msg));
    }

    public void error(Marker marker, String format, Object arg) {
        this.delegate.error(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg));
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.error(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arg1, arg2));
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.delegate.error(marker, this.manipulateLogMessage(format), this.manipulateLogArguments(arguments));
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.delegate.error(marker, this.getExceptionToLog(msg, t));
    }

    public void error(String msg) {
        this.delegate.error(this.manipulateLogMessage(msg));
    }

    public String getName() {
        return "CAS Delegating Logger";
    }
}

