/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.AccountDisabledException;
import org.jasig.cas.authentication.AccountPasswordMustChangeException;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.InvalidLoginLocationException;
import org.jasig.cas.authentication.InvalidLoginTimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;

public class AuthenticationExceptionHandler {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String DEFAULT_MESSAGE_BUNDLE_PREFIX = "authenticationFailure.";
    private static final List<Class<? extends Exception>> DEFAULT_ERROR_LIST = new ArrayList<Class<? extends Exception>>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private List<Class<? extends Exception>> errors = DEFAULT_ERROR_LIST;
    private String messageBundlePrefix = "authenticationFailure.";

    public void setErrors(List<Class<? extends Exception>> errors) {
        this.errors = errors;
    }

    public final List<Class<? extends Exception>> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void setMessageBundlePrefix(String prefix) {
        this.messageBundlePrefix = prefix;
    }

    public String handle(AuthenticationException e, MessageContext messageContext) {
        if (e != null) {
            MessageBuilder builder = new MessageBuilder();
            for (Class<? extends Exception> kind : this.errors) {
                for (Class handlerError : e.getHandlerErrors().values()) {
                    if (handlerError == null || !handlerError.equals(kind)) continue;
                    String handlerErrorName = handlerError.getSimpleName();
                    String messageCode = this.messageBundlePrefix + handlerErrorName;
                    messageContext.addMessage(builder.error().code(messageCode).build());
                    return handlerErrorName;
                }
            }
        }
        String messageCode = this.messageBundlePrefix + UNKNOWN;
        this.logger.trace("Unable to translate handler errors of the authentication exception {}. Returning {} by default...", (Object)e, (Object)messageCode);
        messageContext.addMessage(new MessageBuilder().error().code(messageCode).build());
        return UNKNOWN;
    }

    static {
        DEFAULT_ERROR_LIST.add(AccountLockedException.class);
        DEFAULT_ERROR_LIST.add(FailedLoginException.class);
        DEFAULT_ERROR_LIST.add(CredentialExpiredException.class);
        DEFAULT_ERROR_LIST.add(AccountNotFoundException.class);
        DEFAULT_ERROR_LIST.add(AccountDisabledException.class);
        DEFAULT_ERROR_LIST.add(InvalidLoginLocationException.class);
        DEFAULT_ERROR_LIST.add(AccountPasswordMustChangeException.class);
        DEFAULT_ERROR_LIST.add(InvalidLoginTimeException.class);
    }
}

