/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.ticket.TicketState;
import org.jasig.cas.ticket.support.AbstractCasExpirationPolicy;

public final class HardTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = 6728077010285422290L;
    private final long timeToKillInMilliSeconds;

    private HardTimeoutExpirationPolicy() {
        this.timeToKillInMilliSeconds = 0L;
    }

    public HardTimeoutExpirationPolicy(long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
    }

    public HardTimeoutExpirationPolicy(long timeToKill, TimeUnit timeUnit) {
        this.timeToKillInMilliSeconds = timeUnit.toMillis(timeToKill);
    }

    public boolean isExpired(TicketState ticketState) {
        return ticketState == null || System.currentTimeMillis() - ticketState.getCreationTime() >= this.timeToKillInMilliSeconds;
    }
}

