/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import org.jasig.cas.monitor.MemoryStatus;
import org.jasig.cas.monitor.Monitor;
import org.jasig.cas.monitor.StatusCode;

public class MemoryMonitor
implements Monitor<MemoryStatus> {
    public static final int DEFAULT_FREE_MEMORY_WARN_THRESHOLD = 10;
    private static final int PERCENTAGE_VALUE = 100;
    private long freeMemoryWarnThreshold = 10L;

    public void setFreeMemoryWarnThreshold(long threshold) {
        if (threshold < 0L) {
            throw new IllegalArgumentException("Warning threshold must be non-negative.");
        }
        this.freeMemoryWarnThreshold = threshold;
    }

    public String getName() {
        return MemoryMonitor.class.getSimpleName();
    }

    public MemoryStatus observe() {
        long total;
        long free = Runtime.getRuntime().freeMemory();
        StatusCode code = free * 100L / (total = Runtime.getRuntime().totalMemory()) < this.freeMemoryWarnThreshold ? StatusCode.WARN : StatusCode.OK;
        return new MemoryStatus(code, free, total);
    }
}

