/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasig.cas.authentication.principal.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultResponse
implements Response {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponse.class);
    private static final Pattern NON_PRINTABLE = Pattern.compile("[\\x00-\\x1F\\x7F]+");
    private static final int CONST_REDIRECT_RESPONSE_MULTIPLIER = 40;
    private static final int CONST_REDIRECT_RESPONSE_BUFFER = 100;
    private static final long serialVersionUID = -8251042088720603062L;
    private final Response.ResponseType responseType;
    private final String url;
    private final Map<String, String> attributes;

    protected DefaultResponse(Response.ResponseType responseType, String url, Map<String, String> attributes) {
        this.responseType = responseType;
        this.url = url;
        this.attributes = attributes;
    }

    public static Response getPostResponse(String url, Map<String, String> attributes) {
        return new DefaultResponse(Response.ResponseType.POST, url, attributes);
    }

    public static Response getRedirectResponse(String url, Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder(parameters.size() * 40 + 100);
        boolean isFirst = true;
        String[] fragmentSplit = DefaultResponse.sanitizeUrl(url).split("#");
        builder.append(fragmentSplit[0]);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            if (isFirst) {
                builder.append(url.contains("?") ? "&" : "?");
                isFirst = false;
            } else {
                builder.append('&');
            }
            builder.append(entry.getKey());
            builder.append('=');
            try {
                builder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (Exception e) {
                builder.append(entry.getValue());
            }
        }
        if (fragmentSplit.length > 1) {
            builder.append('#');
            builder.append(fragmentSplit[1]);
        }
        return new DefaultResponse(Response.ResponseType.REDIRECT, builder.toString(), parameters);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Response.ResponseType getResponseType() {
        return this.responseType;
    }

    public String getUrl() {
        return this.url;
    }

    private static String sanitizeUrl(String url) {
        Matcher m = NON_PRINTABLE.matcher(url);
        StringBuffer sb = new StringBuffer(url.length());
        boolean hasNonPrintable = false;
        while (m.find()) {
            m.appendReplacement(sb, " ");
            hasNonPrintable = true;
        }
        m.appendTail(sb);
        if (hasNonPrintable) {
            LOGGER.warn("The following redirect URL has been sanitized and may be sign of attack:\n{}", (Object)url);
        }
        return sb.toString();
    }
}

