/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.authentication.AbstractAuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.UnsupportedCredentialsException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;

public class LinkedAuthenticationHandlerAndCredentialsToPrincipalResolverAuthenticationManager
extends AbstractAuthenticationManager {
    @NotNull
    @Size(min=1)
    private final Map<AuthenticationHandler, CredentialsToPrincipalResolver> linkedHandlers;

    public LinkedAuthenticationHandlerAndCredentialsToPrincipalResolverAuthenticationManager(Map<AuthenticationHandler, CredentialsToPrincipalResolver> linkedHandlers) {
        this.linkedHandlers = linkedHandlers;
    }

    @Override
    protected AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials credentials) throws AuthenticationException {
        boolean foundOneThatWorks = false;
        for (AuthenticationHandler authenticationHandler : this.linkedHandlers.keySet()) {
            if (!authenticationHandler.supports(credentials)) continue;
            foundOneThatWorks = true;
            boolean authenticated = false;
            String handlerName = authenticationHandler.getClass().getName();
            try {
                authenticated = authenticationHandler.authenticate(credentials);
            }
            catch (Exception e) {
                this.handleError(handlerName, credentials, e);
            }
            if (authenticated) {
                this.log.info("{} successfully authenticated {}", (Object)handlerName, (Object)credentials);
                Principal p = this.linkedHandlers.get(authenticationHandler).resolvePrincipal(credentials);
                return new AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal>(authenticationHandler, p);
            }
            this.log.info("{} failed to authenticate {}", (Object)handlerName, (Object)credentials);
        }
        if (foundOneThatWorks) {
            throw BadCredentialsAuthenticationException.ERROR;
        }
        throw UnsupportedCredentialsException.ERROR;
    }
}

