/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.css.WrappedCssStyleDeclaration;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleRuleImpl;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSStyleDeclaration;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.util.StringUtils;

@JsxClass
public class CSSStyleRule
extends CSSRule {
    private static final Pattern SELECTOR_PARTS_PATTERN = Pattern.compile("[.#]?[a-zA-Z]+");
    private static final Pattern SELECTOR_REPLACE_PATTERN = Pattern.compile("\\*([.#])");

    public CSSStyleRule() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected CSSStyleRule(CSSStyleSheet stylesheet, CSSStyleRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @JsxGetter
    public String getSelectorText() {
        String selectorText = ((CSSStyleRuleImpl)this.getRule()).getSelectorText();
        Matcher m = SELECTOR_PARTS_PATTERN.matcher(selectorText);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String fixedName = m.group();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECTOR_TEXT_LOWERCASE) && !fixedName.isEmpty() && '.' != fixedName.charAt(0) && '#' != fixedName.charAt(0)) {
                fixedName = fixedName.toLowerCase(Locale.ROOT);
            }
            fixedName = StringUtils.sanitizeForAppendReplacement(fixedName);
            m.appendReplacement(sb, fixedName);
        }
        m.appendTail(sb);
        selectorText = SELECTOR_REPLACE_PATTERN.matcher(sb.toString()).replaceAll("$1");
        return selectorText;
    }

    @JsxSetter
    public void setSelectorText(String selectorText) {
        ((CSSStyleRuleImpl)this.getRule()).setSelectorText(selectorText);
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        WrappedCssStyleDeclaration styleDeclaration = new WrappedCssStyleDeclaration(((CSSStyleRuleImpl)this.getRule()).getStyle(), this.getBrowserVersion());
        return new CSSStyleDeclaration(this.getParentStyleSheet(), styleDeclaration);
    }
}

