/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.nio.charset.Charset;
import java.util.Locale;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.htmlunit.cyberneko.xerces.util.StandardEncodingTranslator;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.util.XUserDefinedCharset;

@JsxClass
public class TextDecoder
extends HtmlUnitScriptable {
    private String whatwgEncoding_ = "utf-8";

    @JsxConstructor
    public void jsConstructor(Object encodingLabel) {
        if (JavaScriptEngine.isUndefined(encodingLabel)) {
            return;
        }
        String enc = JavaScriptEngine.toString(encodingLabel);
        String whatwgEncoding = (String)StandardEncodingTranslator.ENCODING_FROM_LABEL.get(enc = enc.trim().toLowerCase(Locale.ROOT));
        if (whatwgEncoding == null || "replacement".equalsIgnoreCase(whatwgEncoding)) {
            throw JavaScriptEngine.rangeError("Failed to construct 'TextDecoder': The encoding label provided ('" + encodingLabel + "') is invalid.");
        }
        this.whatwgEncoding_ = whatwgEncoding;
    }

    @JsxGetter
    public String getEncoding() {
        return this.whatwgEncoding_;
    }

    @JsxFunction
    public String decode(Object buffer) {
        if (JavaScriptEngine.isUndefined(buffer)) {
            return "";
        }
        NativeArrayBuffer arrayBuffer = null;
        if (buffer instanceof NativeArrayBuffer) {
            arrayBuffer = (NativeArrayBuffer)buffer;
        } else if (buffer instanceof NativeArrayBufferView) {
            arrayBuffer = ((NativeArrayBufferView)buffer).getBuffer();
        }
        if (arrayBuffer != null) {
            if ("x-user-defined".equalsIgnoreCase(this.whatwgEncoding_)) {
                return new String(arrayBuffer.getBuffer(), XUserDefinedCharset.INSTANCE);
            }
            String ianaEncoding = StandardEncodingTranslator.ENCODING_TO_IANA_ENCODING.getOrDefault(this.whatwgEncoding_, this.whatwgEncoding_);
            String javaEncoding = StandardEncodingTranslator.IANA_TO_JAVA_ENCODINGS.getOrDefault(ianaEncoding, ianaEncoding);
            return new String(arrayBuffer.getBuffer(), Charset.forName(javaEncoding));
        }
        throw JavaScriptEngine.typeError("Argument 1 of TextDecoder.decode could not be converted to any of: ArrayBufferView, ArrayBuffer.");
    }
}

