/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.FormEncodingType;
import org.htmlunit.HttpMethod;
import org.htmlunit.Page;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebWindow;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlDialog;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.http.HttpUtils;
import org.htmlunit.javascript.host.event.SubmitEvent;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.util.EncodingSniffer;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;
import org.htmlunit.util.UrlUtils;

public class HtmlForm
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlForm.class);
    public static final String TAG_NAME = "form";
    private static final String ATTRIBUTE_NOVALIDATE = "novalidate";
    public static final String ATTRIBUTE_FORMNOVALIDATE = "formnovalidate";
    private static final HashSet<String> SUBMITTABLE_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("input", "button", "select", "textarea", "isindex"));
    private static final Pattern SUBMIT_CHARSET_PATTERN = Pattern.compile("[ ,].*");
    private boolean isPreventDefault_;

    HtmlForm(String qualifiedName, SgmlPage htmlPage, Map<String, DomAttr> attributes) {
        super(qualifiedName, htmlPage, attributes);
    }

    public void submit(SubmittableElement submitElement) {
        String methodAttribute;
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        WebClient webClient = htmlPage.getWebClient();
        if (webClient.isJavaScriptEnabled()) {
            String action;
            if (submitElement != null) {
                HtmlButton htmlButton;
                this.isPreventDefault_ = false;
                boolean validate = true;
                if (submitElement instanceof HtmlSubmitInput && ((HtmlSubmitInput)submitElement).isFormNoValidate()) {
                    validate = false;
                } else if (submitElement instanceof HtmlButton && "submit".equalsIgnoreCase((htmlButton = (HtmlButton)submitElement).getType()) && htmlButton.isFormNoValidate()) {
                    validate = false;
                }
                if (validate && this.getAttributeDirect(ATTRIBUTE_NOVALIDATE) != ATTRIBUTE_NOT_DEFINED) {
                    validate = false;
                }
                if (validate && !this.areChildrenValid()) {
                    return;
                }
                ScriptResult scriptResult = this.fireEvent(new SubmitEvent((DomNode)this, (HTMLElement)((HtmlElement)((Object)submitElement)).getScriptableObject()));
                if (this.isPreventDefault_) {
                    if (scriptResult == null) {
                        return;
                    }
                    return;
                }
            }
            if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)(action = this.getActionAttribute().trim()), (CharSequence)"javascript:")) {
                htmlPage.executeJavaScript(action, "Form action", this.getStartLineNumber());
                return;
            }
        } else if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)this.getActionAttribute(), (CharSequence)"javascript:")) {
            return;
        }
        if (submitElement != null) {
            this.updateHtml5Attributes(submitElement);
        }
        if ("dialog".equalsIgnoreCase(methodAttribute = this.getMethodAttribute())) {
            HtmlElement dialog = this.getEnclosingElement("dialog");
            if (dialog != null) {
                ((HtmlDialog)dialog).close("");
            }
            return;
        }
        WebRequest request = this.getWebRequest(submitElement);
        String target = htmlPage.getResolvedTarget(this.getTargetAttribute());
        WebWindow webWindow = htmlPage.getEnclosingWindow();
        webClient.download(webWindow, target, request, false, false, null, "JS form.submit()");
    }

    private void updateHtml5Attributes(SubmittableElement submitElement) {
        if (submitElement instanceof HtmlElement) {
            String formenctype;
            String formtarget;
            String formmethod;
            HtmlElement element = (HtmlElement)((Object)submitElement);
            String type = element.getAttributeDirect("type");
            boolean typeImage = false;
            boolean isInput = "input".equals(element.getTagName());
            if (isInput) {
                typeImage = "image".equalsIgnoreCase(type);
            }
            boolean typeSubmit = "submit".equalsIgnoreCase(type);
            if (isInput && !typeSubmit && !typeImage) {
                return;
            }
            if ("button".equals(element.getTagName()) && !"submit".equals(((HtmlButton)element).getType())) {
                return;
            }
            String formaction = element.getAttributeDirect("formaction");
            if (DomElement.ATTRIBUTE_NOT_DEFINED != formaction) {
                this.setActionAttribute(formaction);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != (formmethod = element.getAttributeDirect("formmethod"))) {
                this.setMethodAttribute(formmethod);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != (formtarget = element.getAttributeDirect("formtarget"))) {
                this.setTargetAttribute(formtarget);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != (formenctype = element.getAttributeDirect("formenctype"))) {
                this.setEnctypeAttribute(formenctype);
            }
        }
    }

    private boolean areChildrenValid() {
        boolean valid = true;
        for (HtmlElement element : this.getElements()) {
            if (!(element instanceof HtmlInput) || element.isValid()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Form validation failed; element '" + element + "' was not valid. Submit cancelled."));
            }
            valid = false;
            break;
        }
        return valid;
    }

    public WebRequest getWebRequest(SubmittableElement submitElement) {
        WebRequest request;
        BrowserVersion browser;
        HttpMethod method;
        block16: {
            URL url;
            HtmlPage htmlPage = (HtmlPage)this.getPage();
            List<NameValuePair> parameters = this.getParameterListForSubmit(submitElement);
            String methodAttribute = this.getMethodAttribute();
            if ("post".equalsIgnoreCase(methodAttribute)) {
                method = HttpMethod.POST;
            } else {
                if (!"get".equalsIgnoreCase(methodAttribute) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)methodAttribute)) {
                    this.notifyIncorrectness("Incorrect submit method >" + this.getMethodAttribute() + "<. Using >GET<.");
                }
                method = HttpMethod.GET;
            }
            browser = this.getPage().getWebClient().getBrowserVersion();
            String actionUrl = this.getActionAttribute();
            String anchor = null;
            String queryFormFields = "";
            Charset enc = this.getSubmitCharset();
            if (StandardCharsets.UTF_16 == enc || StandardCharsets.UTF_16BE == enc || StandardCharsets.UTF_16LE == enc) {
                enc = StandardCharsets.UTF_8;
            }
            if (HttpMethod.GET == method) {
                if (actionUrl.contains("#")) {
                    anchor = org.apache.commons.lang3.StringUtils.substringAfter((String)actionUrl, (String)"#");
                }
                queryFormFields = HttpUtils.toQueryFormFields(parameters, enc);
                actionUrl = org.apache.commons.lang3.StringUtils.substringBefore((String)actionUrl, (String)"#");
                actionUrl = org.apache.commons.lang3.StringUtils.substringBefore((String)actionUrl, (String)"?");
                parameters.clear();
            }
            try {
                url = actionUrl.isEmpty() ? WebClient.expandUrl(htmlPage.getUrl(), actionUrl) : htmlPage.getFullyQualifiedUrl(actionUrl);
                if (!queryFormFields.isEmpty()) {
                    url = UrlUtils.getUrlWithNewQuery(url, queryFormFields);
                }
                if (anchor != null && UrlUtils.URL_ABOUT_BLANK != url) {
                    url = UrlUtils.getUrlWithNewRef(url, anchor);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Not a valid url: " + actionUrl, e);
            }
            request = new WebRequest(url, browser.getHtmlAcceptHeader(), browser.getAcceptEncodingHeader());
            request.setHttpMethod(method);
            request.setRequestParameters(parameters);
            if (HttpMethod.POST == method) {
                request.setEncodingType(FormEncodingType.getInstance(this.getEnctypeAttribute()));
            }
            request.setCharset(enc);
            if (browser.hasFeature(BrowserVersionFeatures.FORM_IGNORE_REL_NOREFERRER) || !this.relContainsNoreferrer()) {
                request.setRefererlHeader(htmlPage.getUrl());
            }
            if (HttpMethod.POST == method) {
                try {
                    request.setAdditionalHeader("Origin", UrlUtils.getUrlWithProtocolAndAuthority(htmlPage.getUrl()).toExternalForm());
                }
                catch (MalformedURLException e) {
                    if (!LOG.isWarnEnabled()) break block16;
                    LOG.info((Object)("Invalid origin url '" + htmlPage.getUrl() + "'"));
                }
            }
        }
        if (HttpMethod.POST == method && browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_HEADER_CACHE_CONTROL_MAX_AGE)) {
            request.setAdditionalHeader("Cache-Control", "max-age=0");
        }
        return request;
    }

    private boolean relContainsNoreferrer() {
        String rel = this.getRelAttribute();
        if (rel != null) {
            rel = rel.toLowerCase(Locale.ROOT);
            return ArrayUtils.contains((Object[])StringUtils.splitAtBlank(rel), (Object)"noreferrer");
        }
        return false;
    }

    private Charset getSubmitCharset() {
        String charset = this.getAcceptCharsetAttribute();
        if (!charset.isEmpty()) {
            charset = charset.trim();
            return EncodingSniffer.toCharset(SUBMIT_CHARSET_PATTERN.matcher(charset).replaceAll("").toUpperCase(Locale.ROOT));
        }
        return this.getPage().getCharset();
    }

    public List<NameValuePair> getParameterListForSubmit(SubmittableElement submitElement) {
        Collection<SubmittableElement> submittableElements = this.getSubmittableElements(submitElement);
        ArrayList<NameValuePair> parameterList = new ArrayList<NameValuePair>(submittableElements.size());
        for (SubmittableElement element : submittableElements) {
            parameterList.addAll(Arrays.asList(element.getSubmitNameValuePairs()));
        }
        return parameterList;
    }

    public Page reset() {
        SgmlPage htmlPage = this.getPage();
        ScriptResult scriptResult = this.fireEvent("reset");
        if (ScriptResult.isFalse(scriptResult)) {
            return htmlPage.getWebClient().getCurrentWindow().getEnclosedPage();
        }
        for (HtmlElement next : this.getHtmlElementDescendants()) {
            if (!(next instanceof SubmittableElement)) continue;
            ((SubmittableElement)((Object)next)).reset();
        }
        return htmlPage;
    }

    @Override
    public boolean isValid() {
        for (HtmlElement element : this.getElements()) {
            if (element.isValid()) continue;
            return false;
        }
        return super.isValid();
    }

    Collection<SubmittableElement> getSubmittableElements(SubmittableElement submitElement) {
        ArrayList<SubmittableElement> submittableElements = new ArrayList<SubmittableElement>();
        for (HtmlElement element : this.getElements()) {
            if (!HtmlForm.isSubmittable(element, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)element));
        }
        return submittableElements;
    }

    private static boolean isValidForSubmission(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        String tagName = element.getTagName();
        if (!SUBMITTABLE_ELEMENT_NAMES.contains(tagName)) {
            return false;
        }
        if (element.hasAttribute("disabled")) {
            return false;
        }
        if (element == submitElement && element instanceof HtmlImageInput) {
            return true;
        }
        if (!"isindex".equals(tagName) && !element.hasAttribute("name")) {
            return false;
        }
        if (!"isindex".equals(tagName) && "".equals(element.getAttributeDirect("name"))) {
            return false;
        }
        if (element instanceof HtmlInput && (input = (HtmlInput)element).isCheckable()) {
            return ((HtmlInput)element).isChecked();
        }
        if ("select".equals(tagName)) {
            return ((HtmlSelect)element).isValidForSubmission();
        }
        return true;
    }

    private static boolean isSubmittable(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        if (!HtmlForm.isValidForSubmission(element, submitElement)) {
            return false;
        }
        if (element == submitElement) {
            return true;
        }
        if (element instanceof HtmlInput && !(input = (HtmlInput)element).isSubmitable()) {
            return false;
        }
        return !"button".equals(element.getTagName());
    }

    public List<HtmlInput> getInputsByName(String name) {
        return this.getFormElementsByAttribute("input", "name", name);
    }

    private <E extends HtmlElement> List<E> getFormElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase(Locale.ROOT);
        for (HtmlElement element : this.getElements()) {
            String attValue;
            if (!element.getTagName().equals(lowerCaseTagName) || !(attValue = element.getAttribute(attributeName)).equals(attributeValue)) continue;
            list.add(element);
        }
        return list;
    }

    public List<HtmlElement> getElements() {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        if (this.isAttachedToPage()) {
            for (HtmlElement element : this.getPage().getDocumentElement().getHtmlElementDescendants()) {
                if (!SUBMITTABLE_ELEMENT_NAMES.contains(element.getTagName()) || element.getEnclosingForm() != this) continue;
                elements.add(element);
            }
        } else {
            for (HtmlElement element : this.getHtmlElementDescendants()) {
                if (!SUBMITTABLE_ELEMENT_NAMES.contains(element.getTagName())) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public final <I extends HtmlInput> I getInputByName(String name) throws ElementNotFoundException {
        List<HtmlInput> inputs = this.getInputsByName(name);
        if (inputs.isEmpty()) {
            throw new ElementNotFoundException("input", "name", name);
        }
        return (I)inputs.get(0);
    }

    public List<HtmlSelect> getSelectsByName(String name) {
        return this.getFormElementsByAttribute("select", "name", name);
    }

    public HtmlSelect getSelectByName(String name) throws ElementNotFoundException {
        List<HtmlSelect> list = this.getSelectsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("select", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlButton> getButtonsByName(String name) {
        return this.getFormElementsByAttribute("button", "name", name);
    }

    public HtmlButton getButtonByName(String name) throws ElementNotFoundException {
        List<HtmlButton> list = this.getButtonsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("button", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlTextArea> getTextAreasByName(String name) {
        return this.getFormElementsByAttribute("textarea", "name", name);
    }

    public HtmlTextArea getTextAreaByName(String name) throws ElementNotFoundException {
        List<HtmlTextArea> list = this.getTextAreasByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("textarea", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlRadioButtonInput> getRadioButtonsByName(String name) {
        WebAssert.notNull("name", name);
        ArrayList<HtmlRadioButtonInput> results = new ArrayList<HtmlRadioButtonInput>();
        for (HtmlElement htmlElement : this.getInputsByName(name)) {
            if (!(htmlElement instanceof HtmlRadioButtonInput)) continue;
            results.add((HtmlRadioButtonInput)htmlElement);
        }
        return results;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        if (radioButtonInput.getEnclosingForm() == null) {
            throw new IllegalArgumentException("HtmlRadioButtonInput is not child of this HtmlForm");
        }
        List<HtmlRadioButtonInput> radios = this.getRadioButtonsByName(radioButtonInput.getNameAttribute());
        for (HtmlRadioButtonInput input : radios) {
            input.setCheckedInternal(input == radioButtonInput);
        }
    }

    public HtmlRadioButtonInput getCheckedRadioButton(String name) {
        WebAssert.notNull("name", name);
        for (HtmlRadioButtonInput input : this.getRadioButtonsByName(name)) {
            if (!input.isChecked()) continue;
            return input;
        }
        return null;
    }

    public final String getActionAttribute() {
        return this.getAttributeDirect("action");
    }

    public final void setActionAttribute(String action) {
        this.setAttribute("action", action);
    }

    public final String getMethodAttribute() {
        return this.getAttributeDirect("method");
    }

    public final void setMethodAttribute(String method) {
        this.setAttribute("method", method);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttribute("name", name);
    }

    public final String getEnctypeAttribute() {
        return this.getAttributeDirect("enctype");
    }

    public final void setEnctypeAttribute(String encoding) {
        this.setAttribute("enctype", encoding);
    }

    public final String getOnSubmitAttribute() {
        return this.getAttributeDirect("onsubmit");
    }

    public final String getOnResetAttribute() {
        return this.getAttributeDirect("onreset");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAcceptCharsetAttribute() {
        return this.getAttribute("accept-charset");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    public final void setTargetAttribute(String target) {
        this.setAttribute("target", target);
    }

    public final String getRelAttribute() {
        return this.getAttributeDirect("rel");
    }

    public <I extends HtmlInput> I getInputByValue(String value) throws ElementNotFoundException {
        List<HtmlInput> list = this.getInputsByValue(value);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("input", "value", value);
        }
        return (I)list.get(0);
    }

    public List<HtmlInput> getInputsByValue(String value) {
        ArrayList<HtmlInput> results = new ArrayList<HtmlInput>();
        for (HtmlElement element : this.getElements()) {
            if (!(element instanceof HtmlInput) || !Objects.equals(((HtmlInput)element).getValue(), value)) continue;
            results.add((HtmlInput)element);
        }
        return results;
    }

    @Override
    protected void preventDefault() {
        this.isPreventDefault_ = true;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    public final boolean isNoValidate() {
        return this.hasAttribute(ATTRIBUTE_NOVALIDATE);
    }

    public final void setNoValidate(boolean noValidate) {
        if (noValidate) {
            this.setAttribute(ATTRIBUTE_NOVALIDATE, ATTRIBUTE_NOVALIDATE);
        } else {
            this.removeAttribute(ATTRIBUTE_NOVALIDATE);
        }
    }
}

