/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.attachment;

import org.htmlunit.Page;
import org.htmlunit.WebResponse;

public class Attachment {
    private final Page page_;
    private final String attachmentFilename_;

    public Attachment(Page page) {
        this(page, null);
    }

    public Attachment(Page page, String attachmentFilename) {
        this.page_ = page;
        this.attachmentFilename_ = attachmentFilename;
    }

    public Page getPage() {
        return this.page_;
    }

    public String getSuggestedFilename() {
        if (this.attachmentFilename_ != null) {
            return this.attachmentFilename_;
        }
        WebResponse response = this.page_.getWebResponse();
        String disp = response.getResponseHeaderValue("Content-Disposition");
        return Attachment.getSuggestedFilename(disp);
    }

    public static String getSuggestedFilename(String contentDispositonHeader) {
        if (contentDispositonHeader == null) {
            return null;
        }
        int start = contentDispositonHeader.indexOf("filename=");
        if (start == -1) {
            return null;
        }
        if ((start += "filename=".length()) >= contentDispositonHeader.length()) {
            return null;
        }
        int end = contentDispositonHeader.indexOf(59, start);
        if (end == -1) {
            end = contentDispositonHeader.length();
        }
        if (contentDispositonHeader.charAt(start) == '\"' && contentDispositonHeader.charAt(end - 1) == '\"') {
            ++start;
            --end;
        }
        return contentDispositonHeader.substring(start, end);
    }
}

