/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.service;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.query.QueryHelper;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.dictionary.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.entity.DictionaryItemEntity;
import org.hswebframework.web.dictionary.event.ClearDictionaryCacheEvent;
import org.hswebframework.web.dictionary.service.DefaultDictionaryItemService;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDictionaryService
extends GenericReactiveCrudService<DictionaryEntity, String> {
    @Autowired
    private DefaultDictionaryItemService itemService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public Mono<Integer> insert(Publisher<DictionaryEntity> entityPublisher) {
        return super.insert(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<DictionaryEntity>> entityPublisher) {
        return super.insertBatch(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> updateById(String id, Mono<DictionaryEntity> entityPublisher) {
        return super.updateById((Object)id, entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return super.deleteById(idPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<SaveResult> save(Publisher<DictionaryEntity> entityPublisher) {
        return super.save(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public ReactiveUpdate<DictionaryEntity> createUpdate() {
        return super.createUpdate().onExecute((ignore, r) -> r.doOnSuccess(l -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of())));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((ignore, r) -> r.doOnSuccess(l -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of())));
    }

    public Mono<DictionaryEntity> findDetailById(String id) {
        return this.findById(Mono.just((Object)id)).zipWith(((ReactiveQuery)((ReactiveQuery)this.itemService.createQuery().where(DictionaryItemEntity::getDictId, (Object)id)).orderBy(new SortOrder[]{SortOrder.asc(DictionaryItemEntity::getOrdinal)})).fetch().collectList(), (dic, items) -> {
            dic.setItems((List<DictionaryItemEntity>)items);
            return dic;
        });
    }

    public Flux<DictionaryEntity> findAllDetail(QueryParamEntity paramEntity, boolean allowEmptyItem) {
        return (Flux)((ReactiveQuery)this.createQuery().setParam((QueryParam)paramEntity)).fetch().as(flux -> this.fillDetail((Flux<DictionaryEntity>)flux, allowEmptyItem));
    }

    public Flux<DictionaryEntity> fillDetail(Flux<DictionaryEntity> dictionary, boolean allowEmptyItem) {
        return QueryHelper.combineOneToMany(dictionary, GenericEntity::getId, (ReactiveQuery)this.itemService.createQuery(), DictionaryItemEntity::getDictId, DictionaryEntity::setItems).filter(dict -> allowEmptyItem || CollectionUtils.isNotEmpty(dict.getItems()));
    }
}

