/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hswebframework.web.dict.EnumDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(prefix="hsweb.dict")
public class DictionaryProperties {
    private static final Logger log = LoggerFactory.getLogger(DictionaryProperties.class);
    private Set<String> enumPackages = new HashSet<String>();

    public List<Class> doScanEnum() {
        HashSet<String> packages = new HashSet<String>(this.enumPackages);
        packages.add("org.hswebframework.web");
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String enumPackage : packages) {
            Resource[] resources;
            String path = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)enumPackage) + "/**/*.class";
            for (Resource resource : resources = resourcePatternResolver.getResources(path)) {
                try {
                    MetadataReader reader = metadataReaderFactory.getMetadataReader(resource);
                    String name = reader.getClassMetadata().getClassName();
                    Class clazz = ClassUtils.forName((String)name, null);
                    if (!clazz.isEnum() || !EnumDict.class.isAssignableFrom(clazz)) continue;
                    classes.add(clazz);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        metadataReaderFactory.clearCache();
        return classes;
    }

    public Set<String> getEnumPackages() {
        return this.enumPackages;
    }

    public void setEnumPackages(Set<String> enumPackages) {
        this.enumPackages = enumPackages;
    }
}

