/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.initialize;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.ezorm.core.Decoder;
import org.hswebframework.ezorm.core.Encoder;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.codec.ClobValueCodec;
import org.hswebframework.ezorm.rdb.codec.CompositeValueCodec;
import org.hswebframework.ezorm.rdb.codec.JsonValueCodec;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.SyncRepository;
import org.hswebframework.ezorm.rdb.mapping.SyncUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.Record;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.starter.initialize.Dependency;
import org.hswebframework.web.starter.initialize.SimpleDependencyInstaller;
import org.hswebframework.web.starter.initialize.SystemVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;

public class SystemInitialize {
    private final Logger logger = LoggerFactory.getLogger(SystemInitialize.class);
    private final DatabaseOperator database;
    private final SystemVersion targetVersion;
    private SystemVersion installed;
    private List<SimpleDependencyInstaller> readyToInstall = new ArrayList<SimpleDependencyInstaller>();
    private List<String> excludeTables;
    private String installScriptPath = "classpath*:hsweb-starter.js";
    private Map<String, Object> scriptContext = new HashMap<String, Object>();
    private boolean initialized = false;
    private SyncRepository<Record, String> system;

    public SystemInitialize(DatabaseOperator database, SystemVersion targetVersion) {
        this.database = database;
        this.targetVersion = targetVersion;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.scriptContext.put("database", this.database);
        this.scriptContext.put("logger", this.logger);
        this.initialized = true;
    }

    public void addScriptContext(String var, Object val) {
        this.scriptContext.put(var, val);
    }

    protected void syncSystemVersion() {
        Map mapVersion = (Map)FastBeanCopier.copy((Object)this.targetVersion, HashMap::new, (String[])new String[0]);
        if (this.installed == null) {
            this.system.insert((Object)Record.newRecord((Map)mapVersion));
        } else {
            for (Dependency dependency : this.installed.getDependencies()) {
                Dependency target = this.targetVersion.getDependency(dependency.getGroupId(), dependency.getArtifactId());
                if (target != null) continue;
                this.targetVersion.getDependencies().add(dependency);
            }
            mapVersion = (Map)FastBeanCopier.copy((Object)this.targetVersion, HashMap::new, (String[])new String[0]);
            ((SyncUpdate)((SyncUpdate)this.system.createUpdate().set((Object)Record.newRecord((Map)mapVersion))).where(dsl -> {
                SyncUpdate cfr_ignored_0 = (SyncUpdate)dsl.is(this.targetVersion::getName);
            })).execute();
        }
    }

    protected Map<String, Object> getScriptContext() {
        return new HashMap<String, Object>(this.scriptContext);
    }

    protected void doInstall() {
        ArrayList doInitializeDep = new ArrayList();
        List<Dependency> installedDependencies = this.readyToInstall.stream().map(installer -> {
            Dependency dependency = installer.getDependency();
            Dependency installed = this.getInstalledDependency(dependency.getGroupId(), dependency.getArtifactId());
            if (installed == null) {
                doInitializeDep.add(installer);
                installer.doInstall(this.getScriptContext());
            }
            if (installed == null || installed.compareTo(dependency) < 0) {
                installer.doUpgrade(this.getScriptContext(), installed);
            }
            return dependency;
        }).collect(Collectors.toList());
        for (SimpleDependencyInstaller installer2 : doInitializeDep) {
            installer2.doInitialize(this.getScriptContext());
        }
        this.targetVersion.setDependencies(installedDependencies);
    }

    private Dependency getInstalledDependency(String groupId, String artifactId) {
        if (this.installed == null) {
            return null;
        }
        return this.installed.getDependency(groupId, artifactId);
    }

    private SimpleDependencyInstaller getReadyToInstallDependency(String groupId, String artifactId) {
        if (this.readyToInstall == null) {
            return null;
        }
        return this.readyToInstall.stream().filter(installer -> installer.getDependency().isSameDependency(groupId, artifactId)).findFirst().orElse(null);
    }

    private void initReadyToInstallDependencies() {
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)"js");
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(this.installScriptPath);
            ArrayList<SimpleDependencyInstaller> installers = new ArrayList<SimpleDependencyInstaller>();
            for (Resource resource : resources) {
                String script = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.forName("utf-8"));
                SimpleDependencyInstaller installer = new SimpleDependencyInstaller();
                engine.compile("__tmp", script);
                Map<String, Object> context = this.getScriptContext();
                context.put("dependency", installer);
                engine.execute("__tmp", context).getIfSuccess();
                installers.add(installer);
            }
            this.readyToInstall = installers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            engine.remove("__tmp");
        }
    }

    protected void initInstallInfo() {
        boolean tableInstall = this.database.getMetadata().getTable("s_system").isPresent();
        this.database.ddl().createOrAlter("s_system").addColumn().name("name").varchar(128).comment("\u7cfb\u7edf\u540d\u79f0").commit().addColumn().name("major_version").alias("majorVersion").integer().comment("\u4e3b\u7248\u672c\u53f7").commit().addColumn().name("minor_version").alias("minorVersion").integer().comment("\u6b21\u7248\u672c\u53f7").commit().addColumn().name("revision_version").alias("revisionVersion").integer().comment("\u4fee\u8ba2\u7248").commit().addColumn().name("comment").varchar(2000).comment("\u7cfb\u7edf\u8bf4\u660e").commit().addColumn().name("website").varchar(2000).comment("\u7cfb\u7edf\u7f51\u5740").commit().addColumn().name("framework_version").notNull().alias("frameworkVersion").clob().custom(column -> column.setValueCodec((ValueCodec)new CompositeValueCodec().addEncoder((Encoder)JsonValueCodec.of(SystemVersion.FrameworkVersion.class)).addDecoder((Decoder)ClobValueCodec.INSTANCE).addDecoder((Decoder)JsonValueCodec.of(SystemVersion.FrameworkVersion.class)))).notNull().comment("\u6846\u67b6\u7248\u672c").commit().addColumn().name("dependencies").notNull().alias("dependencies").clob().custom(column -> column.setValueCodec((ValueCodec)new CompositeValueCodec().addEncoder((Encoder)JsonValueCodec.ofCollection(List.class, Dependency.class)).addDecoder((Decoder)ClobValueCodec.INSTANCE).addDecoder((Decoder)JsonValueCodec.ofCollection(List.class, Dependency.class)))).notNull().comment("\u4f9d\u8d56\u8be6\u60c5").commit().comment("\u7cfb\u7edf\u4fe1\u606f").allowAlter(false).commit().sync();
        this.system = this.database.dml().createRepository("s_system");
        if (!tableInstall) {
            this.installed = null;
            return;
        }
        this.installed = ((SyncQuery)((SyncQuery)this.system.createQuery().where(dsl -> {
            SyncQuery cfr_ignored_0 = (SyncQuery)dsl.is("name", (Object)this.targetVersion.getName());
        })).paging(0, 1)).fetchOne().map(r -> (SystemVersion)FastBeanCopier.copy((Object)r, SystemVersion::new, (String[])new String[0])).orElse(null);
    }

    public void install() throws Exception {
        this.init();
        this.initInstallInfo();
        this.initReadyToInstallDependencies();
        this.doInstall();
        this.syncSystemVersion();
    }

    public void setExcludeTables(List<String> excludeTables) {
        this.excludeTables = excludeTables;
    }

    public List<String> getExcludeTables() {
        return this.excludeTables;
    }
}

