/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.i18n;

import java.util.stream.Collectors;
import org.hswebframework.web.i18n.MessageSourceInitializer;
import org.hswebframework.web.starter.i18n.CompositeMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=-2147483648)
public class I18nConfiguration {
    private static final Logger log = LoggerFactory.getLogger(I18nConfiguration.class);

    @Bean
    public MessageSource autoResolveI18nMessageSource() {
        Resource[] resources;
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setDefaultEncoding("UTF-8");
        for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("classpath*:i18n/**")) {
            String path = resource.getURL().getPath();
            if (!StringUtils.hasText((String)path) || !path.endsWith(".properties") && !path.endsWith(".xml")) continue;
            CharSequence[] split = (path = path.substring(path.lastIndexOf("i18n"))).split("[/|\\\\]");
            String name = split[split.length - 1];
            split[split.length - 1] = name = name.contains("_") ? name.substring(0, name.indexOf("_")) : name;
            log.info("register i18n message resource {} -> {}", (Object)path, (Object)name);
            messageSource.addBasenames(new String[]{String.join((CharSequence)"/", split)});
        }
        return messageSource;
    }

    @Bean
    @Primary
    public MessageSource compositeMessageSource(ObjectProvider<MessageSource> objectProvider) {
        CompositeMessageSource messageSource = new CompositeMessageSource();
        messageSource.addMessageSources(objectProvider.stream().collect(Collectors.toList()));
        MessageSourceInitializer.init((MessageSource)messageSource);
        return messageSource;
    }
}

