/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateParser {
    private static final Logger log = LoggerFactory.getLogger(TemplateParser.class);
    private static final char[] DEFAULT_PREPARE_START_SYMBOL = "${".toCharArray();
    private static final char[] DEFAULT_PREPARE_END_SYMBOL = "}".toCharArray();
    private char[] prepareStartSymbol = DEFAULT_PREPARE_START_SYMBOL;
    private char[] prepareEndSymbol = DEFAULT_PREPARE_END_SYMBOL;
    private String template;
    private Object parameter;
    private char[] templateArray;
    private int pos;
    private char symbol;
    private char[] newArr;
    private int len = 0;
    private byte prepareFlag = 0;

    public void setParsed(char[] chars, int end) {
        for (int i = 0; i < end; ++i) {
            char aChar = chars[i];
            if (this.newArr.length <= this.len) {
                this.newArr = Arrays.copyOf(this.newArr, this.len + this.templateArray.length);
            }
            this.newArr[this.len++] = aChar;
        }
    }

    public void setParsed(char ... chars) {
        this.setParsed(chars, chars.length);
    }

    private void init() {
        this.templateArray = this.template.toCharArray();
        this.pos = 0;
        this.newArr = new char[this.templateArray.length * 2];
    }

    private boolean isPreparing() {
        return this.prepareFlag > 0;
    }

    private boolean isPrepare() {
        if (this.prepareStartSymbol[this.prepareFlag] == this.symbol) {
            this.prepareFlag = (byte)(this.prepareFlag + 1);
        }
        if (this.prepareFlag >= this.prepareStartSymbol.length) {
            this.prepareFlag = 0;
            return true;
        }
        return false;
    }

    private boolean isPrepareEnd() {
        for (char c : this.prepareEndSymbol) {
            if (c != this.symbol) continue;
            return true;
        }
        return false;
    }

    private boolean next() {
        this.symbol = this.templateArray[this.pos++];
        return this.pos < this.templateArray.length;
    }

    public String parse(Function<String, String> propertyMapping) {
        this.init();
        boolean inPrepare = false;
        char[] expression = new char[128];
        int expressionPos = 0;
        while (this.next()) {
            if (this.isPrepare()) {
                inPrepare = true;
                continue;
            }
            if (inPrepare && this.isPrepareEnd()) {
                inPrepare = false;
                this.setParsed(propertyMapping.apply(new String(expression, 0, expressionPos)).toCharArray());
                expressionPos = 0;
                continue;
            }
            if (inPrepare) {
                expression[expressionPos++] = this.symbol;
                continue;
            }
            if (this.isPreparing()) continue;
            this.setParsed(this.symbol);
        }
        if (this.isPrepareEnd() && expressionPos > 0) {
            this.setParsed(propertyMapping.apply(new String(expression, 0, expressionPos)).toCharArray());
        } else {
            this.setParsed(this.symbol);
        }
        return new String(this.newArr, 0, this.len);
    }

    public static String parse(String template, Object parameter) {
        return TemplateParser.parse(template, (String var) -> {
            try {
                return BeanUtilsBean.getInstance().getProperty(parameter, var);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                return "";
            }
        });
    }

    public static String parse(String template, Function<String, String> parameterGetter) {
        TemplateParser parser = new TemplateParser();
        parser.template = template;
        return parser.parse(parameterGetter);
    }

    public char[] getPrepareStartSymbol() {
        return this.prepareStartSymbol;
    }

    public void setPrepareStartSymbol(char[] prepareStartSymbol) {
        this.prepareStartSymbol = prepareStartSymbol;
    }

    public char[] getPrepareEndSymbol() {
        return this.prepareEndSymbol;
    }

    public void setPrepareEndSymbol(char[] prepareEndSymbol) {
        this.prepareEndSymbol = prepareEndSymbol;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }
}

