/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class ModuleUtils {
    private static final Logger log = LoggerFactory.getLogger(ModuleUtils.class);
    private static final Map<Class, ModuleInfo> classModuleInfoRepository = new ConcurrentHashMap<Class, ModuleInfo>();
    private static final Map<String, ModuleInfo> nameModuleInfoRepository = new ConcurrentHashMap<String, ModuleInfo>();
    private static final ModuleInfo noneInfo;

    private ModuleUtils() {
    }

    public static ModuleInfo getModuleByClass(Class type) {
        return classModuleInfoRepository.computeIfAbsent(type, ModuleUtils::parse);
    }

    public static String getClassPath(Class type) {
        boolean isJar;
        ProtectionDomain domain = type.getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return ModuleUtils.getClassPath(type.getResource("").getPath(), type.getPackage().getName());
        }
        String path = codeSource.getLocation().toString();
        boolean bl = isJar = path.contains("!/") && path.contains(".jar");
        if (isJar) {
            return path.substring(0, path.lastIndexOf(".jar") + 4);
        }
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getClassPath(String path, String packages) {
        boolean isJar;
        if (path.endsWith(".jar")) {
            return path;
        }
        boolean bl = isJar = path.contains("!/") && path.contains(".jar");
        if (isJar) {
            return path.substring(0, path.lastIndexOf(".jar") + 4);
        }
        int pos = path.endsWith("/") ? 2 : 1;
        return path.substring(0, path.length() - packages.length() - pos);
    }

    private static ModuleInfo parse(Class type) {
        String classpath = ModuleUtils.getClassPath(type);
        return nameModuleInfoRepository.values().stream().filter(moduleInfo -> classpath.equals(((ModuleInfo)moduleInfo).classPath)).findFirst().orElse(noneInfo);
    }

    public static ModuleInfo getModule(String id) {
        return nameModuleInfoRepository.get(id);
    }

    public static void register(ModuleInfo moduleInfo) {
        nameModuleInfoRepository.put(moduleInfo.getId(), moduleInfo);
    }

    static {
        try {
            Resource[] resources;
            log.info("init module info");
            for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("classpath*:/hsweb-module.json")) {
                String classPath = ModuleUtils.getClassPath(resource.getURL().toString(), "hsweb-module.json");
                ModuleInfo moduleInfo = (ModuleInfo)JSON.parseObject((InputStream)resource.getInputStream(), ModuleInfo.class, (Feature[])new Feature[0]);
                moduleInfo.setClassPath(classPath);
                ModuleUtils.register(moduleInfo);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        noneInfo = new ModuleInfo();
    }

    public static class ModuleInfo {
        private String classPath;
        private String id;
        private String groupId;
        private String path;
        private String artifactId;
        private String gitCommitHash;
        private String gitRepository;
        private String comment;
        private String version;

        public String getGitLocation() {
            String gitCommitHash = this.gitCommitHash;
            if (gitCommitHash == null || gitCommitHash.contains("$") || gitCommitHash.contains("@")) {
                gitCommitHash = "master";
            }
            return this.gitRepository + "/blob/" + gitCommitHash + "/" + this.path + "/";
        }

        public String getGitClassLocation(Class clazz) {
            return this.getGitLocation() + "src/main/java/" + ClassUtils.getPackageName((Class)clazz).replace(".", "/") + "/" + clazz.getSimpleName() + ".java";
        }

        public String getGitClassLocation(Class clazz, long line, long lineTo) {
            return this.getGitLocation() + "src/main/java/" + ClassUtils.getPackageName((Class)clazz).replace(".", "/") + "/" + clazz.getSimpleName() + ".java#L" + line + "-L" + lineTo;
        }

        public String getId() {
            if (StringUtils.isEmpty((Object)this.id)) {
                this.id = this.groupId + "/" + this.artifactId;
            }
            return this.id;
        }

        public boolean isNone() {
            return StringUtils.isEmpty((Object)this.classPath);
        }

        public String getClassPath() {
            return this.classPath;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getPath() {
            return this.path;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getGitCommitHash() {
            return this.gitCommitHash;
        }

        public String getGitRepository() {
            return this.gitRepository;
        }

        public String getComment() {
            return this.comment;
        }

        public String getVersion() {
            return this.version;
        }

        public void setClassPath(String classPath) {
            this.classPath = classPath;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public void setGitCommitHash(String gitCommitHash) {
            this.gitCommitHash = gitCommitHash;
        }

        public void setGitRepository(String gitRepository) {
            this.gitRepository = gitRepository;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

