/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanMap;
import org.hswebframework.utils.time.DateFormatter;
import org.springframework.util.ClassUtils;

public class HttpParameterConverter {
    private Map<String, Object> beanMap;
    private Map<String, String> parameter = new HashMap<String, String>();
    private String prefix = "";
    private static final Map<Class, Function<Object, String>> convertMap = new HashMap<Class, Function<Object, String>>();
    private static Function<Object, String> defaultConvert = String::valueOf;
    private static final Set<Class> basicClass = new HashSet<Class>();

    private static <T> void putConvert(Class<T> type, Function<T, String> convert) {
        convertMap.put(type, convert);
    }

    private String convertValue(Object value) {
        return convertMap.getOrDefault(value.getClass(), defaultConvert).apply(value);
    }

    public HttpParameterConverter(Object bean) {
        if (bean instanceof Map) {
            this.beanMap = (Map)bean;
        } else {
            this.beanMap = new HashMap<String, Object>((Map<String, Object>)new BeanMap(bean));
            this.beanMap.remove("class");
            this.beanMap.remove("declaringClass");
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private void doConvert(String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Class) {
            return;
        }
        Class type = ClassUtils.getUserClass((Object)value);
        if (basicClass.contains(type) || value instanceof Number || value instanceof Enum) {
            this.parameter.put(this.getParameterKey(key), this.convertValue(value));
            return;
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            Collection coll = value;
            int count = 0;
            for (Object o : coll) {
                this.doConvert(key + "[" + count++ + "]", o);
            }
        } else {
            HttpParameterConverter converter = new HttpParameterConverter(value);
            converter.setPrefix(this.getParameterKey(key).concat("."));
            this.parameter.putAll(converter.convert());
        }
    }

    private void doConvert() {
        this.beanMap.forEach(this::doConvert);
    }

    private String getParameterKey(String property) {
        return this.prefix.concat(property);
    }

    public Map<String, String> convert() {
        this.doConvert();
        return this.parameter;
    }

    static {
        basicClass.add(Integer.TYPE);
        basicClass.add(Double.TYPE);
        basicClass.add(Float.TYPE);
        basicClass.add(Byte.TYPE);
        basicClass.add(Short.TYPE);
        basicClass.add(Character.TYPE);
        basicClass.add(Boolean.TYPE);
        basicClass.add(Integer.class);
        basicClass.add(Double.class);
        basicClass.add(Float.class);
        basicClass.add(Byte.class);
        basicClass.add(Short.class);
        basicClass.add(Character.class);
        basicClass.add(String.class);
        basicClass.add(Boolean.class);
        basicClass.add(Date.class);
        HttpParameterConverter.putConvert(Date.class, date -> DateFormatter.toString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

