/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.exception;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.hswebframework.web.exception.BusinessException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.BAD_REQUEST)
public class ValidationException
extends BusinessException {
    private List<Detail> details;

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(String property, String message) {
        this(message, Collections.singletonList(new Detail(property, message, null)));
    }

    public ValidationException(String message, List<Detail> details) {
        super(message);
        this.details = details;
    }

    public ValidationException(String message, Set<? extends ConstraintViolation<?>> violations) {
        super(message);
        if (null != violations && !violations.isEmpty()) {
            this.details = new ArrayList<Detail>();
            for (ConstraintViolation<?> violation : violations) {
                this.details.add(new Detail(violation.getPropertyPath().toString(), violation.getMessage(), null));
            }
        }
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public void setDetails(List<Detail> details) {
        this.details = details;
    }

    public static class Detail {
        @Schema(description="\u5b57\u6bb5")
        String property;
        @Schema(description="\u8bf4\u660e")
        String message;
        @Schema(description="\u8be6\u60c5")
        Object detail;

        public String getProperty() {
            return this.property;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getDetail() {
            return this.detail;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setDetail(Object detail) {
            this.detail = detail;
        }

        @ConstructorProperties(value={"property", "message", "detail"})
        public Detail(String property, String message, Object detail) {
            this.property = property;
            this.message = message;
            this.detail = detail;
        }
    }
}

