/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.bean;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.dict.EnumDict;

public abstract class CompareUtils {
    public static boolean compare(Object source, Object target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.equals(target)) {
            return true;
        }
        if (source instanceof Number) {
            return CompareUtils.compare((Number)source, target);
        }
        if (target instanceof Number) {
            return CompareUtils.compare((Number)target, source);
        }
        if (source instanceof Date) {
            return CompareUtils.compare((Date)source, target);
        }
        if (target instanceof Date) {
            return CompareUtils.compare((Date)target, source);
        }
        if (source instanceof String) {
            return CompareUtils.compare((String)source, target);
        }
        if (target instanceof String) {
            return CompareUtils.compare((String)target, source);
        }
        if (source instanceof Collection) {
            return CompareUtils.compare((Collection)source, target);
        }
        if (target instanceof Collection) {
            return CompareUtils.compare((Collection)target, source);
        }
        if (source instanceof Map) {
            return CompareUtils.compare((Map)source, target);
        }
        if (target instanceof Map) {
            return CompareUtils.compare((Map)target, source);
        }
        if (source.getClass().isEnum()) {
            return CompareUtils.compare((Enum)source, target);
        }
        if (target.getClass().isEnum()) {
            return CompareUtils.compare((Enum)target, source);
        }
        if (source.getClass().isArray()) {
            return CompareUtils.compare((Object[])source, target);
        }
        if (target.getClass().isArray()) {
            return CompareUtils.compare((Object[])target, source);
        }
        return CompareUtils.compare(FastBeanCopier.copy(source, HashMap.class, new String[0]), (Object)FastBeanCopier.copy(target, HashMap.class, new String[0]));
    }

    public static boolean compare(Map<?, ?> map, Object target) {
        if (map == target) {
            return true;
        }
        if (map == null || target == null) {
            return false;
        }
        Map targetMap = null;
        targetMap = target instanceof Map ? (Map)target : (Map)FastBeanCopier.copy(target, HashMap::new, new String[0]);
        if (map.size() != targetMap.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (CompareUtils.compare(entry.getValue(), targetMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(Collection collection, Object target) {
        if (collection == target) {
            return true;
        }
        if (collection == null || target == null) {
            return false;
        }
        List<Object> targetCollection = null;
        if (target instanceof String) {
            target = ((String)target).split("[, ;]");
        }
        if (target instanceof Collection) {
            targetCollection = (List<Object>)target;
        } else if (target.getClass().isArray()) {
            targetCollection = Arrays.asList((Object[])target);
        }
        if (targetCollection == null) {
            return false;
        }
        HashSet<Object> left = new HashSet(collection);
        HashSet<Object> right = new HashSet<Object>(targetCollection);
        if (left.size() < right.size()) {
            HashSet<Object> tmp = right;
            right = left;
            left = tmp;
        }
        for (Object source : left) {
            if (right.stream().anyMatch(targetObj -> CompareUtils.compare(source, targetObj))) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(Object[] number, Object target) {
        return CompareUtils.compare(Arrays.asList(number), target);
    }

    public static boolean compare(Boolean bool, Object target) {
        return bool.equals(target) || String.valueOf(bool).equals(target);
    }

    public static boolean compare(Number number, Object target) {
        if (number == target) {
            return true;
        }
        if (number == null || target == null) {
            return false;
        }
        if (target.equals(number)) {
            return true;
        }
        if (target instanceof Number) {
            return number.doubleValue() == ((Number)target).doubleValue();
        }
        if (target instanceof Date) {
            return number.longValue() == ((Date)target).getTime();
        }
        if (target instanceof String) {
            String stringValue = String.valueOf(target);
            if (DateFormatter.isSupport((String)stringValue)) {
                DateFormatter dateFormatter = DateFormatter.getFormatter((String)stringValue);
                return dateFormatter.toString(new Date(number.longValue())).equals(stringValue);
            }
            try {
                return new BigDecimal(stringValue).doubleValue() == number.doubleValue();
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean compare(Enum e, Object target) {
        if (e == target) {
            return true;
        }
        if (e == null || target == null) {
            return false;
        }
        String stringValue = String.valueOf(target);
        if (e instanceof EnumDict) {
            EnumDict dict = (EnumDict)((Object)e);
            return e.name().equalsIgnoreCase(stringValue) || dict.eq(target);
        }
        return e.name().equalsIgnoreCase(stringValue);
    }

    public static boolean compare(String string, Object target) {
        if (string == target) {
            return true;
        }
        if (string == null || target == null) {
            return false;
        }
        if (string.equals(String.valueOf(target))) {
            return true;
        }
        if (target instanceof Enum) {
            return CompareUtils.compare((Enum)target, (Object)string);
        }
        if (target instanceof Date) {
            return CompareUtils.compare((Date)target, (Object)string);
        }
        if (target instanceof Number) {
            return CompareUtils.compare((Number)target, (Object)string);
        }
        if (target instanceof Collection) {
            return CompareUtils.compare((Collection)target, (Object)string);
        }
        return false;
    }

    public static boolean compare(Date date, Object target) {
        String stringValue;
        if (date == target) {
            return true;
        }
        if (date == null || target == null) {
            return false;
        }
        if (target instanceof Date) {
            return date.getTime() == ((Date)target).getTime();
        }
        if (target instanceof String && DateFormatter.isSupport((String)(stringValue = String.valueOf(target)))) {
            DateFormatter dateFormatter = DateFormatter.getFormatter((String)stringValue);
            return dateFormatter.toString(date).equals(stringValue);
        }
        if (target instanceof Number) {
            long longValue = ((Number)target).longValue();
            return date.getTime() == longValue;
        }
        return false;
    }
}

