/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.aop;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.aop.MethodInterceptorContext;
import org.hswebframework.web.utils.AnnotationUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.DigestUtils;
import reactor.core.publisher.Mono;

public class MethodInterceptorHolder {
    public static final ParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final String id;
    private final Method method;
    private final Object target;
    private final Object[] arguments;
    private final String[] argumentsNames;
    private final Map<String, Object> namedArguments;

    public static MethodInterceptorHolder create(MethodInvocation invocation) {
        String id = DigestUtils.md5DigestAsHex((byte[])String.valueOf(invocation.getMethod().hashCode()).getBytes());
        String[] argNames = nameDiscoverer.getParameterNames(invocation.getMethod());
        Object[] args = invocation.getArguments();
        LinkedHashMap<String, Object> argMap = new LinkedHashMap<String, Object>();
        String[] names = new String[args.length];
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            names[i] = argNames == null || argNames.length <= i || argNames[i] == null ? "arg" + i : argNames[i];
            argMap.put(names[i], args[i]);
        }
        return new MethodInterceptorHolder(id, invocation.getMethod(), invocation.getThis(), args, names, argMap);
    }

    public <T extends Annotation> T findMethodAnnotation(Class<T> annClass) {
        return AnnotationUtils.findMethodAnnotation(annClass, this.method, annClass);
    }

    public <T extends Annotation> T findClassAnnotation(Class<T> annClass) {
        return AnnotationUtils.findAnnotation(this.target.getClass(), annClass);
    }

    public <T extends Annotation> T findAnnotation(Class<T> annClass) {
        return AnnotationUtils.findAnnotation(this.target.getClass(), this.method, annClass);
    }

    public MethodInterceptorContext createParamContext() {
        return this.createParamContext(null);
    }

    public MethodInterceptorContext createParamContext(final Object invokeResult) {
        return new MethodInterceptorContext(){
            private static final long serialVersionUID = -4102787561601219273L;
            private Object result;
            {
                this.result = invokeResult;
            }

            @Override
            public Object[] getArguments() {
                return MethodInterceptorHolder.this.arguments;
            }

            @Override
            public boolean handleReactiveArguments(Function<Publisher<?>, Publisher<?>> handler) {
                boolean handled = false;
                Object[] args = this.getArguments();
                if (args == null || args.length == 0) {
                    return false;
                }
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    if (!(arg instanceof Publisher)) continue;
                    args[i] = handler.apply((Publisher<?>)((Mono)arg));
                    handled = true;
                }
                return handled;
            }

            @Override
            public Object getTarget() {
                return MethodInterceptorHolder.this.target;
            }

            @Override
            public Method getMethod() {
                return MethodInterceptorHolder.this.method;
            }

            @Override
            public <T> Optional<T> getArgument(String name) {
                if (MethodInterceptorHolder.this.namedArguments == null) {
                    return Optional.empty();
                }
                return Optional.ofNullable(MethodInterceptorHolder.this.namedArguments.get(name));
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annClass) {
                return MethodInterceptorHolder.this.findAnnotation(annClass);
            }

            @Override
            public Map<String, Object> getNamedArguments() {
                return MethodInterceptorHolder.this.getNamedArguments();
            }

            @Override
            public Object getInvokeResult() {
                return this.result;
            }

            @Override
            public void setInvokeResult(Object result) {
                this.result = result;
            }
        };
    }

    @ConstructorProperties(value={"id", "method", "target", "arguments", "argumentsNames", "namedArguments"})
    public MethodInterceptorHolder(String id, Method method, Object target, Object[] arguments, String[] argumentsNames, Map<String, Object> namedArguments) {
        this.id = id;
        this.method = method;
        this.target = target;
        this.arguments = arguments;
        this.argumentsNames = argumentsNames;
        this.namedArguments = namedArguments;
    }

    public String getId() {
        return this.id;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String[] getArgumentsNames() {
        return this.argumentsNames;
    }

    public Map<String, Object> getNamedArguments() {
        return this.namedArguments;
    }
}

