/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.net.InetSocketAddress;
import java.util.Optional;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;

public class ReactiveWebUtils {
    static final String[] ipHeaders = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP"};

    public static String getIpAddr(ServerHttpRequest request) {
        for (String ipHeader : ipHeaders) {
            String ip = request.getHeaders().getFirst(ipHeader);
            if (StringUtils.isEmpty((Object)ip) || ip.contains("unknown")) continue;
            return ip;
        }
        return Optional.ofNullable(request.getRemoteAddress()).map(InetSocketAddress::getHostName).orElse("unknown");
    }
}

