/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.web.utils.TemplateParser;

public class ExpressionUtils {
    private static final Pattern PATTERN = Pattern.compile("(?<=\\$\\{)(.+?)(?=})");

    public static Map<String, Object> getDefaultVar() {
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> getDefaultVar(Map<String, Object> var) {
        Map<String, Object> vars = ExpressionUtils.getDefaultVar();
        vars.putAll(var);
        return vars;
    }

    public static String analytical(String expression, String language) throws Exception {
        return ExpressionUtils.analytical(expression, new HashMap<String, Object>(), language);
    }

    public static String analytical(String expression, Map<String, Object> vars, String language) {
        if (!expression.contains("${")) {
            return expression;
        }
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)language);
        if (engine == null) {
            return expression;
        }
        return TemplateParser.parse(expression, var -> {
            Object fast = vars.get(var);
            if (fast != null) {
                return fast.toString();
            }
            String id = DigestUtils.md5Hex((String)var);
            try {
                if (!engine.compiled(id)) {
                    engine.compile(id, var);
                }
                return String.valueOf(engine.execute(id, vars).getIfSuccess());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

