/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> T findMethodAnnotation(Class targetClass, Method method, Class<T> annClass) {
        Method m = method;
        Annotation a = org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)m, annClass);
        if (a != null) {
            return (T)a;
        }
        a = org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)(m = ClassUtils.getMostSpecificMethod((Method)m, (Class)targetClass)), annClass);
        if (a == null) {
            ArrayList supers = new ArrayList(Arrays.asList(targetClass.getInterfaces()));
            if (targetClass.getSuperclass() != Object.class) {
                supers.add(targetClass.getSuperclass());
            }
            for (Class clazz : supers) {
                if (clazz == null) continue;
                AtomicReference methodRef = new AtomicReference();
                ReflectionUtils.doWithMethods((Class)clazz, im -> {
                    if (im.getName().equals(method.getName()) && im.getParameterCount() == method.getParameterCount()) {
                        methodRef.set(im);
                    }
                });
                if (methodRef.get() == null || (a = AnnotationUtils.findMethodAnnotation(clazz, (Method)methodRef.get(), annClass)) == null) continue;
                return (T)a;
            }
        }
        return (T)a;
    }

    public static <T extends Annotation> T findAnnotation(Class targetClass, Class<T> annClass) {
        return (T)org.springframework.core.annotation.AnnotationUtils.findAnnotation((Class)targetClass, annClass);
    }

    public static <T extends Annotation> T findAnnotation(Class targetClass, Method method, Class<T> annClass) {
        T a = AnnotationUtils.findMethodAnnotation(targetClass, method, annClass);
        if (a != null) {
            return a;
        }
        return AnnotationUtils.findAnnotation(targetClass, annClass);
    }

    public static <T extends Annotation> T findAnnotation(JoinPoint pjp, Class<T> annClass) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method m = signature.getMethod();
        Class<?> targetClass = pjp.getTarget().getClass();
        return AnnotationUtils.findAnnotation(targetClass, m, annClass);
    }

    public static String getMethodBody(JoinPoint pjp) {
        StringBuilder methodName = new StringBuilder(pjp.getSignature().getName()).append("(");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String[] names = signature.getParameterNames();
        Class[] args = signature.getParameterTypes();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                methodName.append(",");
            }
            methodName.append(args[i].getSimpleName()).append(" ").append(names[i]);
        }
        return methodName.append(")").toString();
    }

    public static Map<String, Object> getArgsMap(JoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        String[] names = signature.getParameterNames();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            args.put(names[i], pjp.getArgs()[i]);
        }
        return args;
    }
}

