/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logger;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.SynchronousSink;
import reactor.util.context.Context;

public class ReactiveLogger {
    private static final Logger log = LoggerFactory.getLogger(ReactiveLogger.class);
    private static String CONTEXT_KEY = ReactiveLogger.class.getName();

    public static Function<Context, Context> start(String key, String value) {
        return ReactiveLogger.start(Collections.singletonMap(key, value));
    }

    public static Mono<Void> mdc(String key, String value) {
        return Mono.empty().subscriberContext(ReactiveLogger.start(key, value));
    }

    public static Function<Context, Context> start(Map<String, String> context) {
        return ctx -> {
            Optional maybeContextMap = ctx.getOrEmpty((Object)CONTEXT_KEY);
            if (maybeContextMap.isPresent()) {
                ((Map)maybeContextMap.get()).putAll(context);
                return ctx;
            }
            return ctx.put((Object)CONTEXT_KEY, new LinkedHashMap(context));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void log(Context context, Consumer<Map<String, String>> logger) {
        Optional maybeContextMap = context.getOrEmpty((Object)CONTEXT_KEY);
        if (!maybeContextMap.isPresent()) {
            logger.accept(new HashMap());
        } else {
            Map ctx = (Map)maybeContextMap.get();
            MDC.setContextMap((Map)ctx);
            try {
                logger.accept(ctx);
            }
            finally {
                MDC.clear();
            }
        }
    }

    public static <T> Consumer<Signal<T>> on(SignalType type, BiConsumer<Map<String, String>, Signal<T>> logger) {
        return signal -> {
            if (signal.getType() != type) {
                return;
            }
            Optional maybeContextMap = signal.getContext().getOrEmpty((Object)CONTEXT_KEY);
            if (!maybeContextMap.isPresent()) {
                logger.accept(new HashMap(), (Signal)signal);
            } else {
                Map ctx = (Map)maybeContextMap.get();
                MDC.setContextMap((Map)ctx);
                try {
                    logger.accept(ctx, (Signal)signal);
                }
                finally {
                    MDC.clear();
                }
            }
        };
    }

    public static Mono<Void> mdc(Consumer<Map<String, String>> consumer) {
        return Mono.subscriberContext().doOnNext(ctx -> {
            Optional maybeContextMap = ctx.getOrEmpty((Object)CONTEXT_KEY);
            if (maybeContextMap.isPresent()) {
                consumer.accept((Map<String, String>)maybeContextMap.get());
            } else {
                consumer.accept(Collections.emptyMap());
                log.warn("logger context is empty,please call publisher.subscriberContext(ReactiveLogger.mdc()) first!");
            }
        }).then();
    }

    public static <T, R> BiConsumer<T, SynchronousSink<R>> handle(BiConsumer<T, SynchronousSink<R>> logger) {
        return (t, rFluxSink) -> ReactiveLogger.log(rFluxSink.currentContext(), context -> logger.accept((Object)t, (SynchronousSink)rFluxSink));
    }

    public static <T> Consumer<Signal<T>> onNext(Consumer<T> logger) {
        return ReactiveLogger.on(SignalType.ON_NEXT, (ctx, signal) -> logger.accept(signal.get()));
    }

    public static <T> Consumer<Signal<T>> onComplete(Runnable logger) {
        return ReactiveLogger.on(SignalType.ON_COMPLETE, (ctx, signal) -> logger.run());
    }

    public static <T> Consumer<Signal<T>> onError(Consumer<Throwable> logger) {
        return ReactiveLogger.on(SignalType.ON_ERROR, (ctx, signal) -> logger.accept(signal.getThrowable()));
    }
}

