/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.exception;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.hswebframework.web.exception.BusinessException;

public class ValidationException
extends BusinessException {
    private List<Detail> details;

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(String message, List<Detail> details) {
        super(message);
        this.details = details;
    }

    public ValidationException(String message, Set<? extends ConstraintViolation> violations) {
        super(message);
        if (null != violations && !violations.isEmpty()) {
            this.details = new ArrayList<Detail>();
            for (ConstraintViolation constraintViolation : violations) {
                this.details.add(new Detail(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage(), null));
            }
        }
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public void setDetails(List<Detail> details) {
        this.details = details;
    }

    public static class Detail {
        String property;
        String message;
        Object detail;

        public String getProperty() {
            return this.property;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getDetail() {
            return this.detail;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setDetail(Object detail) {
            this.detail = detail;
        }

        @ConstructorProperties(value={"property", "message", "detail"})
        public Detail(String property, String message, Object detail) {
            this.property = property;
            this.message = message;
            this.detail = detail;
        }
    }
}

