/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dict.defaults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.dict.Dict;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.DictDefineRepository;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.dict.defaults.DefaultDictDefine;
import org.hswebframework.web.dict.defaults.DefaultItemDefine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDictDefineRepository
implements DictDefineRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultDictDefineRepository.class);
    protected static final Map<String, DictDefine> parsedDict = new HashMap<String, DictDefine>();

    public static void registerDefine(DictDefine define) {
        if (define == null) {
            return;
        }
        parsedDict.put(define.getId(), define);
    }

    public static DictDefine parseEnumDict(Class<?> type) {
        Dict dict = type.getAnnotation(Dict.class);
        if (!type.isEnum()) {
            throw new UnsupportedOperationException("unsupported type " + type);
        }
        ArrayList<EnumDict> items = new ArrayList<EnumDict>();
        for (Object enumConstant : type.getEnumConstants()) {
            if (enumConstant instanceof EnumDict) {
                items.add((EnumDict)enumConstant);
                continue;
            }
            Enum e = (Enum)enumConstant;
            items.add(DefaultItemDefine.builder().value(e.name()).text(e.name()).ordinal(e.ordinal()).build());
        }
        DefaultDictDefine define = new DefaultDictDefine();
        if (dict != null) {
            define.setId(dict.value());
            define.setComments(dict.comments());
            define.setAlias(dict.alias());
        } else {
            String id = StringUtils.camelCase2UnderScoreCase((String)type.getSimpleName()).replace("_", "-");
            if (id.startsWith("-")) {
                id = id.substring(1);
            }
            define.setId(id);
            define.setAlias(type.getSimpleName());
        }
        define.setItems(items);
        log.debug("parse enum dict : {} as : {}", type, (Object)define.getId());
        return define;
    }

    @Override
    public Mono<DictDefine> getDefine(String id) {
        return Mono.justOrEmpty((Object)parsedDict.get(id));
    }

    @Override
    public Flux<DictDefine> getAllDefine() {
        return Flux.fromIterable(parsedDict.values());
    }

    @Override
    public void addDefine(DictDefine dictDefine) {
        DefaultDictDefineRepository.registerDefine(dictDefine);
    }
}

