/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.warn;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class Warning {
    private static final Object CONTEXT_KEY = Warning.class;
    private final String code;
    private final Object[] args;

    public static Context addWarnToContext(ContextView context, Supplier<Warning> warning) {
        Context ctx = Warning.createWarning(context);
        List warnings = (List)ctx.get(CONTEXT_KEY);
        warnings.add(warning.get());
        return ctx;
    }

    public static Context createWarning(ContextView context) {
        Context ctx = Context.of((ContextView)context);
        if (!ctx.hasKey(CONTEXT_KEY)) {
            ctx = ctx.put(CONTEXT_KEY, new CopyOnWriteArrayList());
        }
        return ctx;
    }

    public static <T> Function<Throwable, Flux<T>> resumeFluxError(Throwable error, Function<Throwable, Warning> builder) {
        return err -> Flux.deferContextual(ctx -> {
            Warning warning = (Warning)builder.apply((Throwable)err);
            if (warning != null && ctx.hasKey(CONTEXT_KEY)) {
                ((List)ctx.get(CONTEXT_KEY)).add(warning);
            }
            return Mono.empty();
        });
    }

    public static <T> Function<Throwable, Mono<T>> resumeMonoError(Throwable error, Function<Throwable, Warning> builder) {
        return err -> Mono.deferContextual(ctx -> {
            Warning warning = (Warning)builder.apply((Throwable)err);
            if (warning != null && ctx.hasKey(CONTEXT_KEY)) {
                ((List)ctx.get(CONTEXT_KEY)).add(warning);
            }
            return Mono.empty();
        });
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Warning(String code, Object[] args) {
        this.code = code;
        this.args = args;
    }
}

