/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import io.netty.util.concurrent.FastThreadLocal;
import io.seruco.encoding.base62.Base62;
import java.security.MessageDigest;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Hex;

public class DigestUtils {
    public static final FastThreadLocal<MessageDigest> md5 = new FastThreadLocal<MessageDigest>(){

        protected MessageDigest initialValue() {
            return org.apache.commons.codec.digest.DigestUtils.getMd5Digest();
        }
    };
    public static final FastThreadLocal<MessageDigest> sha256 = new FastThreadLocal<MessageDigest>(){

        protected MessageDigest initialValue() {
            return org.apache.commons.codec.digest.DigestUtils.getSha256Digest();
        }
    };
    public static final FastThreadLocal<MessageDigest> sha1 = new FastThreadLocal<MessageDigest>(){

        protected MessageDigest initialValue() {
            return org.apache.commons.codec.digest.DigestUtils.getSha1Digest();
        }
    };
    private static final Base62 base62 = Base62.createInstance();

    public static Base62 base62() {
        return base62;
    }

    public static byte[] md5(Consumer<MessageDigest> digestHandler) {
        return DigestUtils.digest(() -> md5.get(), digestHandler);
    }

    public static String md5Hex(Consumer<MessageDigest> digestHandler) {
        return DigestUtils.digestHex(() -> md5.get(), digestHandler);
    }

    public static byte[] sha1(Consumer<MessageDigest> digestHandler) {
        return DigestUtils.digest(() -> sha1.get(), digestHandler);
    }

    public static String sha1Hex(Consumer<MessageDigest> digestHandler) {
        return DigestUtils.digestHex(() -> sha1.get(), digestHandler);
    }

    public static byte[] sha256(Consumer<MessageDigest> digestHandler) {
        return DigestUtils.digest(() -> sha256.get(), digestHandler);
    }

    public static String sha256Hex(Consumer<MessageDigest> digestHandler) {
        return DigestUtils.digestHex(() -> sha1.get(), digestHandler);
    }

    public static byte[] md5(byte[] data) {
        return org.apache.commons.codec.digest.DigestUtils.digest((MessageDigest)((MessageDigest)md5.get()), (byte[])data);
    }

    public static byte[] md5(String str) {
        return DigestUtils.md5(str.getBytes());
    }

    public static String md5Hex(String str) {
        return Hex.encodeHexString((byte[])DigestUtils.md5(str.getBytes()));
    }

    public static String md5Base62(String str) {
        return new String(base62.encode(DigestUtils.md5(str.getBytes())));
    }

    public static byte[] sha256(byte[] data) {
        return org.apache.commons.codec.digest.DigestUtils.digest((MessageDigest)((MessageDigest)sha256.get()), (byte[])data);
    }

    public static byte[] sha256(String str) {
        return DigestUtils.sha256(str.getBytes());
    }

    public static String sha256Hex(String str) {
        return Hex.encodeHexString((byte[])DigestUtils.sha256(str.getBytes()));
    }

    public static byte[] sha1(byte[] data) {
        return org.apache.commons.codec.digest.DigestUtils.digest((MessageDigest)((MessageDigest)sha1.get()), (byte[])data);
    }

    public static byte[] sha1(String str) {
        return DigestUtils.sha1(str.getBytes());
    }

    public static String sha1Hex(String str) {
        return Hex.encodeHexString((byte[])DigestUtils.sha1(str.getBytes()));
    }

    public static byte[] digest(MessageDigest digest, byte[] data) {
        return org.apache.commons.codec.digest.DigestUtils.digest((MessageDigest)digest, (byte[])data);
    }

    public static byte[] digest(MessageDigest digest, String str) {
        return DigestUtils.digest(digest, str.getBytes());
    }

    public static String digestHex(MessageDigest digest, String str) {
        return Hex.encodeHexString((byte[])DigestUtils.digest(digest, str));
    }

    private static byte[] digest(Supplier<MessageDigest> digestSupplier, Consumer<MessageDigest> digestHandler) {
        MessageDigest digest = digestSupplier.get();
        digestHandler.accept(digest);
        return digest.digest();
    }

    private static String digestHex(Supplier<MessageDigest> digestSupplier, Consumer<MessageDigest> digestHandler) {
        return Hex.encodeHexString((byte[])DigestUtils.digest(digestSupplier, digestHandler));
    }
}

