/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.proxy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.springframework.util.ClassUtils;

public class Proxy<I>
extends URLClassLoader {
    private static final AtomicLong counter = new AtomicLong(1L);
    private final CtClass ctClass;
    private final Class<I> superClass;
    private final String className;
    private final String classFullName;
    private final List<ClassLoader> loaders = new ArrayList<ClassLoader>();
    private Class<I> targetClass;

    public static <I> Proxy<I> create(Class<I> superClass, Class<?>[] classPaths, String ... classPathString) {
        return new Proxy<I>(superClass, classPaths, classPathString);
    }

    public static <I> Proxy<I> create(Class<I> superClass, String ... classPathString) {
        return new Proxy<I>(superClass, null, classPathString);
    }

    public Proxy(Class<I> superClass, String ... classPathString) {
        this(superClass, (Class<?>[])null, classPathString);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL resource = loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final Enumeration[] tmp = new Enumeration[this.loaders.size()];
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                for (Enumeration urlEnumeration : tmp) {
                    if (!urlEnumeration.hasMoreElements()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                for (Enumeration urlEnumeration : tmp) {
                    if (!urlEnumeration.hasMoreElements()) continue;
                    return (URL)urlEnumeration.nextElement();
                }
                return null;
            }
        };
    }

    private static URL[] toUrl(String[] str) {
        if (str == null || str.length == 0) {
            return new URL[0];
        }
        URL[] arr = new URL[str.length];
        for (int i = 0; i < str.length; ++i) {
            arr[i] = URI.create(str[i]).toURL();
        }
        return arr;
    }

    public Proxy(Class<I> superClass, Class<?>[] classPaths, String ... classPathString) {
        super(Proxy.toUrl(classPathString));
        if (superClass == null) {
            throw new NullPointerException("superClass can not be null");
        }
        this.superClass = superClass;
        ClassPool classPool = ClassPool.getDefault();
        if (classPaths != null) {
            for (Class<?> classPath : classPaths) {
                if (classPath.getClassLoader() == null || classPath.getClassLoader() == this.getClass().getClassLoader()) continue;
                this.loaders.add(classPath.getClassLoader());
            }
        }
        this.loaders.add(ClassUtils.getDefaultClassLoader());
        classPool.insertClassPath((ClassPath)new LoaderClassPath((ClassLoader)this));
        this.className = superClass.getSimpleName() + "$Proxy" + counter.getAndIncrement();
        String packageName = superClass.getPackage().getName();
        if (packageName.startsWith("java")) {
            packageName = "proxy." + packageName;
        }
        this.classFullName = packageName + "." + this.className;
        this.ctClass = classPool.makeClass(this.classFullName);
        if (superClass != Object.class) {
            if (superClass.isInterface()) {
                this.ctClass.setInterfaces(new CtClass[]{classPool.get(superClass.getName())});
            } else {
                this.ctClass.setSuperclass(classPool.get(superClass.getName()));
            }
        }
        this.addConstructor("public " + this.className + "(){}");
    }

    public Proxy<I> addMethod(String code) {
        return this.handleException(() -> this.ctClass.addMethod(CtNewMethod.make((String)code, (CtClass)this.ctClass)));
    }

    public Proxy<I> addConstructor(String code) {
        return this.handleException(() -> this.ctClass.addConstructor(CtNewConstructor.make((String)code, (CtClass)this.ctClass)));
    }

    public Proxy<I> addField(String code) {
        return this.addField(code, null);
    }

    public Proxy<I> addField(String code, Class<? extends Annotation> annotation) {
        return this.addField(code, annotation, null);
    }

    public static MemberValue createMemberValue(Object value, ConstPool constPool) {
        IntegerMemberValue memberValue = null;
        if (value instanceof Integer) {
            memberValue = new IntegerMemberValue(constPool, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            memberValue = new BooleanMemberValue(((Boolean)value).booleanValue(), constPool);
        } else if (value instanceof Long) {
            memberValue = new LongMemberValue(((Long)value).longValue(), constPool);
        } else if (value instanceof String) {
            memberValue = new StringMemberValue((String)value, constPool);
        } else if (value instanceof Class) {
            memberValue = new ClassMemberValue(((Class)value).getName(), constPool);
        } else if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            ArrayMemberValue arrayMemberValue = new ArrayMemberValue((MemberValue)new ClassMemberValue(arr[0].getClass().getName(), constPool), constPool);
            arrayMemberValue.setValue((MemberValue[])Arrays.stream(arr).map(o -> Proxy.createMemberValue(o, constPool)).toArray(MemberValue[]::new));
            memberValue = arrayMemberValue;
        }
        return memberValue;
    }

    public Proxy<I> custom(Consumer<CtClass> ctClassConsumer) {
        ctClassConsumer.accept(this.ctClass);
        return this;
    }

    public Proxy<I> addField(String code, Class<? extends Annotation> annotation, Map<String, Object> annotationProperties) {
        return this.handleException(() -> {
            CtField ctField = CtField.make((String)code, (CtClass)this.ctClass);
            if (null != annotation) {
                ConstPool constPool = this.ctClass.getClassFile().getConstPool();
                AnnotationsAttribute attributeInfo = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                javassist.bytecode.annotation.Annotation ann = new javassist.bytecode.annotation.Annotation(annotation.getName(), constPool);
                if (null != annotationProperties) {
                    annotationProperties.forEach((key, value) -> {
                        MemberValue memberValue = Proxy.createMemberValue(value, constPool);
                        if (memberValue != null) {
                            ann.addMemberValue(key, memberValue);
                        }
                    });
                }
                attributeInfo.addAnnotation(ann);
                ctField.getFieldInfo().addAttribute((AttributeInfo)attributeInfo);
            }
            this.ctClass.addField(ctField);
        });
    }

    private Proxy<I> handleException(Task task) {
        task.run();
        return this;
    }

    public I newInstance() {
        return this.getTargetClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Class<I> getTargetClass() {
        if (this.targetClass == null) {
            byte[] code = this.ctClass.toBytecode();
            this.targetClass = this.defineClass(null, code, 0, code.length);
        }
        return this.targetClass;
    }

    public Class<I> getSuperClass() {
        return this.superClass;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassFullName() {
        return this.classFullName;
    }

    static interface Task {
        public void run() throws Exception;
    }
}

