/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.i18n;

import java.util.Locale;
import org.hswebframework.web.i18n.LocaleUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebFluxLocaleFilter
implements WebFilter {
    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, WebFilterChain chain) {
        return ((Mono)chain.filter(exchange).as(LocaleUtils::transform)).contextWrite(LocaleUtils.useLocale(this.getLocaleContext(exchange)));
    }

    public Locale getLocaleContext(ServerWebExchange exchange) {
        String lang = (String)exchange.getRequest().getQueryParams().getFirst((Object)":lang");
        if (StringUtils.hasText((String)lang)) {
            return Locale.forLanguageTag(lang);
        }
        Locale locale = exchange.getLocaleContext().getLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }
}

