/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.event;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.LinkedList;
import org.hswebframework.web.event.AsyncEvent;
import reactor.core.publisher.Mono;

public class AsyncEventHooks {
    private static final FastThreadLocal<LinkedList<AsyncEventHook>> hooks = new FastThreadLocal<LinkedList<AsyncEventHook>>(){

        protected LinkedList<AsyncEventHook> initialValue() {
            return new LinkedList<AsyncEventHook>();
        }
    };

    public static AutoUnbindable bind(AsyncEventHook hook) {
        LinkedList list = (LinkedList)hooks.get();
        list.add(hook);
        return () -> list.removeLastOccurrence(hook);
    }

    static Mono<?> hookFirst(AsyncEvent event, Mono<?> publisher) {
        LinkedList hooksList = (LinkedList)hooks.getIfExists();
        if (hooksList == null) {
            return publisher;
        }
        for (AsyncEventHook asyncEventHook : hooksList) {
            publisher = asyncEventHook.hookFirst(event, publisher);
        }
        return publisher;
    }

    static Mono<?> hookAsync(AsyncEvent event, Mono<?> publisher) {
        LinkedList hooksList = (LinkedList)hooks.getIfExists();
        if (hooksList == null) {
            return publisher;
        }
        for (AsyncEventHook asyncEventHook : hooksList) {
            publisher = asyncEventHook.hookAsync(event, publisher);
        }
        return publisher;
    }

    public static interface AsyncEventHook {
        default public Mono<?> hookAsync(AsyncEvent event, Mono<?> publisher) {
            return publisher;
        }

        default public Mono<?> hookFirst(AsyncEvent event, Mono<?> publisher) {
            return publisher;
        }
    }

    public static interface AutoUnbindable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

